package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AzurePlatformStatusFluent<A extends AzurePlatformStatusFluent<A>> extends BaseFluent<A>{
  public AzurePlatformStatusFluent() {
  }
  
  public AzurePlatformStatusFluent(AzurePlatformStatus instance) {
    this.copyInstance(instance);
  }
  private String armEndpoint;
  private String cloudName;
  private String networkResourceGroupName;
  private String resourceGroupName;
  private ArrayList<AzureResourceTagBuilder> resourceTags = new ArrayList<AzureResourceTagBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AzurePlatformStatus instance) {
    instance = (instance != null ? instance : new AzurePlatformStatus());
  
    if (instance != null) {
        this.withArmEndpoint(instance.getArmEndpoint());
        this.withCloudName(instance.getCloudName());
        this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
        this.withResourceGroupName(instance.getResourceGroupName());
        this.withResourceTags(instance.getResourceTags());
        this.withArmEndpoint(instance.getArmEndpoint());
        this.withCloudName(instance.getCloudName());
        this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
        this.withResourceGroupName(instance.getResourceGroupName());
        this.withResourceTags(instance.getResourceTags());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getArmEndpoint() {
    return this.armEndpoint;
  }
  
  public A withArmEndpoint(String armEndpoint) {
    this.armEndpoint=armEndpoint; return (A) this;
  }
  
  public boolean hasArmEndpoint() {
    return this.armEndpoint != null;
  }
  
  public String getCloudName() {
    return this.cloudName;
  }
  
  public A withCloudName(String cloudName) {
    this.cloudName=cloudName; return (A) this;
  }
  
  public boolean hasCloudName() {
    return this.cloudName != null;
  }
  
  public String getNetworkResourceGroupName() {
    return this.networkResourceGroupName;
  }
  
  public A withNetworkResourceGroupName(String networkResourceGroupName) {
    this.networkResourceGroupName=networkResourceGroupName; return (A) this;
  }
  
  public boolean hasNetworkResourceGroupName() {
    return this.networkResourceGroupName != null;
  }
  
  public String getResourceGroupName() {
    return this.resourceGroupName;
  }
  
  public A withResourceGroupName(String resourceGroupName) {
    this.resourceGroupName=resourceGroupName; return (A) this;
  }
  
  public boolean hasResourceGroupName() {
    return this.resourceGroupName != null;
  }
  
  public A addToResourceTags(int index,AzureResourceTag item) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AzureResourceTagBuilder>();}
    AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
    if (index < 0 || index >= resourceTags.size()) { _visitables.get("resourceTags").add(builder); resourceTags.add(builder); } else { _visitables.get("resourceTags").add(index, builder); resourceTags.add(index, builder);}
    return (A)this;
  }
  
  public A setToResourceTags(int index,AzureResourceTag item) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AzureResourceTagBuilder>();}
    AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
    if (index < 0 || index >= resourceTags.size()) { _visitables.get("resourceTags").add(builder); resourceTags.add(builder); } else { _visitables.get("resourceTags").set(index, builder); resourceTags.set(index, builder);}
    return (A)this;
  }
  
  public A addToResourceTags(io.fabric8.openshift.api.model.config.v1.AzureResourceTag... items) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AzureResourceTagBuilder>();}
    for (AzureResourceTag item : items) {AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);_visitables.get("resourceTags").add(builder);this.resourceTags.add(builder);} return (A)this;
  }
  
  public A addAllToResourceTags(Collection<AzureResourceTag> items) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AzureResourceTagBuilder>();}
    for (AzureResourceTag item : items) {AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);_visitables.get("resourceTags").add(builder);this.resourceTags.add(builder);} return (A)this;
  }
  
  public A removeFromResourceTags(io.fabric8.openshift.api.model.config.v1.AzureResourceTag... items) {
    if (this.resourceTags == null) return (A)this;
    for (AzureResourceTag item : items) {AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);_visitables.get("resourceTags").remove(builder); this.resourceTags.remove(builder);} return (A)this;
  }
  
  public A removeAllFromResourceTags(Collection<AzureResourceTag> items) {
    if (this.resourceTags == null) return (A)this;
    for (AzureResourceTag item : items) {AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);_visitables.get("resourceTags").remove(builder); this.resourceTags.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromResourceTags(Predicate<AzureResourceTagBuilder> predicate) {
    if (resourceTags == null) return (A) this;
    final Iterator<AzureResourceTagBuilder> each = resourceTags.iterator();
    final List visitables = _visitables.get("resourceTags");
    while (each.hasNext()) {
      AzureResourceTagBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AzureResourceTag> buildResourceTags() {
    return resourceTags != null ? build(resourceTags) : null;
  }
  
  public AzureResourceTag buildResourceTag(int index) {
    return this.resourceTags.get(index).build();
  }
  
  public AzureResourceTag buildFirstResourceTag() {
    return this.resourceTags.get(0).build();
  }
  
  public AzureResourceTag buildLastResourceTag() {
    return this.resourceTags.get(resourceTags.size() - 1).build();
  }
  
  public AzureResourceTag buildMatchingResourceTag(Predicate<AzureResourceTagBuilder> predicate) {
    for (AzureResourceTagBuilder item: resourceTags) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingResourceTag(Predicate<AzureResourceTagBuilder> predicate) {
    for (AzureResourceTagBuilder item: resourceTags) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withResourceTags(List<AzureResourceTag> resourceTags) {
    if (this.resourceTags != null) { _visitables.get("resourceTags").clear();}
    if (resourceTags != null) {this.resourceTags = new ArrayList(); for (AzureResourceTag item : resourceTags){this.addToResourceTags(item);}} else { this.resourceTags = null;} return (A) this;
  }
  
  public A withResourceTags(io.fabric8.openshift.api.model.config.v1.AzureResourceTag... resourceTags) {
    if (this.resourceTags != null) {this.resourceTags.clear(); _visitables.remove("resourceTags"); }
    if (resourceTags != null) {for (AzureResourceTag item :resourceTags){ this.addToResourceTags(item);}} return (A) this;
  }
  
  public boolean hasResourceTags() {
    return resourceTags != null && !resourceTags.isEmpty();
  }
  
  public A addNewResourceTag(String key,String value) {
    return (A)addToResourceTags(new AzureResourceTag(key, value));
  }
  
  public ResourceTagsNested<A> addNewResourceTag() {
    return new ResourceTagsNested(-1, null);
  }
  
  public ResourceTagsNested<A> addNewResourceTagLike(AzureResourceTag item) {
    return new ResourceTagsNested(-1, item);
  }
  
  public ResourceTagsNested<A> setNewResourceTagLike(int index,AzureResourceTag item) {
    return new ResourceTagsNested(index, item);
  }
  
  public ResourceTagsNested<A> editResourceTag(int index) {
    if (resourceTags.size() <= index) throw new RuntimeException("Can't edit resourceTags. Index exceeds size.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  
  public ResourceTagsNested<A> editFirstResourceTag() {
    if (resourceTags.size() == 0) throw new RuntimeException("Can't edit first resourceTags. The list is empty.");
    return setNewResourceTagLike(0, buildResourceTag(0));
  }
  
  public ResourceTagsNested<A> editLastResourceTag() {
    int index = resourceTags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceTags. The list is empty.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  
  public ResourceTagsNested<A> editMatchingResourceTag(Predicate<AzureResourceTagBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceTags.size();i++) { 
    if (predicate.test(resourceTags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceTags. No match found.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AzurePlatformStatusFluent that = (AzurePlatformStatusFluent) o;
    if (!java.util.Objects.equals(armEndpoint, that.armEndpoint)) return false;
  
    if (!java.util.Objects.equals(cloudName, that.cloudName)) return false;
  
    if (!java.util.Objects.equals(networkResourceGroupName, that.networkResourceGroupName)) return false;
  
    if (!java.util.Objects.equals(resourceGroupName, that.resourceGroupName)) return false;
  
    if (!java.util.Objects.equals(resourceTags, that.resourceTags)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(armEndpoint,  cloudName,  networkResourceGroupName,  resourceGroupName,  resourceTags,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (armEndpoint != null) { sb.append("armEndpoint:"); sb.append(armEndpoint + ","); }
    if (cloudName != null) { sb.append("cloudName:"); sb.append(cloudName + ","); }
    if (networkResourceGroupName != null) { sb.append("networkResourceGroupName:"); sb.append(networkResourceGroupName + ","); }
    if (resourceGroupName != null) { sb.append("resourceGroupName:"); sb.append(resourceGroupName + ","); }
    if (resourceTags != null && !resourceTags.isEmpty()) { sb.append("resourceTags:"); sb.append(resourceTags + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ResourceTagsNested<N> extends AzureResourceTagFluent<ResourceTagsNested<N>> implements Nested<N>{
    ResourceTagsNested(int index,AzureResourceTag item) {
      this.index = index;
      this.builder = new AzureResourceTagBuilder(this, item);
    }
    AzureResourceTagBuilder builder;
    int index;
    
    public N and() {
      return (N) AzurePlatformStatusFluent.this.setToResourceTags(index,builder.build());
    }
    
    public N endResourceTag() {
      return and();
    }
    
  
  }

}