package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VSpherePlatformVCenterSpecFluent<A extends VSpherePlatformVCenterSpecFluent<A>> extends BaseFluent<A>{
  public VSpherePlatformVCenterSpecFluent() {
  }
  public VSpherePlatformVCenterSpecFluent(VSpherePlatformVCenterSpec instance) {
    instance = (instance != null ? instance : new VSpherePlatformVCenterSpec());

    if (instance != null) {
      this.withDatacenters(instance.getDatacenters());
      this.withPort(instance.getPort());
      this.withServer(instance.getServer());
      this.withDatacenters(instance.getDatacenters());
      this.withPort(instance.getPort());
      this.withServer(instance.getServer());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> datacenters = new ArrayList<String>();
  private Integer port;
  private String server;
  private Map<String,Object> additionalProperties;
  public A addToDatacenters(int index,String item) {
    if (this.datacenters == null) {this.datacenters = new ArrayList<String>();}
    this.datacenters.add(index, item);
    return (A)this;
  }
  public A setToDatacenters(int index,String item) {
    if (this.datacenters == null) {this.datacenters = new ArrayList<String>();}
    this.datacenters.set(index, item); return (A)this;
  }
  public A addToDatacenters(java.lang.String... items) {
    if (this.datacenters == null) {this.datacenters = new ArrayList<String>();}
    for (String item : items) {this.datacenters.add(item);} return (A)this;
  }
  public A addAllToDatacenters(Collection<String> items) {
    if (this.datacenters == null) {this.datacenters = new ArrayList<String>();}
    for (String item : items) {this.datacenters.add(item);} return (A)this;
  }
  public A removeFromDatacenters(java.lang.String... items) {
    if (this.datacenters == null) return (A)this;
    for (String item : items) { this.datacenters.remove(item);} return (A)this;
  }
  public A removeAllFromDatacenters(Collection<String> items) {
    if (this.datacenters == null) return (A)this;
    for (String item : items) { this.datacenters.remove(item);} return (A)this;
  }
  public List<String> getDatacenters() {
    return this.datacenters;
  }
  public String getDatacenter(int index) {
    return this.datacenters.get(index);
  }
  public String getFirstDatacenter() {
    return this.datacenters.get(0);
  }
  public String getLastDatacenter() {
    return this.datacenters.get(datacenters.size() - 1);
  }
  public String getMatchingDatacenter(Predicate<String> predicate) {
    for (String item: datacenters) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingDatacenter(Predicate<String> predicate) {
    for (String item: datacenters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDatacenters(List<String> datacenters) {
    if (datacenters != null) {this.datacenters = new ArrayList(); for (String item : datacenters){this.addToDatacenters(item);}} else { this.datacenters = null;} return (A) this;
  }
  public A withDatacenters(java.lang.String... datacenters) {
    if (this.datacenters != null) {this.datacenters.clear(); _visitables.remove("datacenters"); }
    if (datacenters != null) {for (String item :datacenters){ this.addToDatacenters(item);}} return (A) this;
  }
  public boolean hasDatacenters() {
    return datacenters != null && !datacenters.isEmpty();
  }
  public Integer getPort() {
    return this.port;
  }
  public A withPort(Integer port) {
    this.port=port; return (A) this;
  }
  public boolean hasPort() {
    return this.port != null;
  }
  public String getServer() {
    return this.server;
  }
  public A withServer(String server) {
    this.server=server; return (A) this;
  }
  public boolean hasServer() {
    return this.server != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VSpherePlatformVCenterSpecFluent that = (VSpherePlatformVCenterSpecFluent) o;
    if (!java.util.Objects.equals(datacenters, that.datacenters)) return false;

    if (!java.util.Objects.equals(port, that.port)) return false;

    if (!java.util.Objects.equals(server, that.server)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(datacenters,  port,  server,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (datacenters != null && !datacenters.isEmpty()) { sb.append("datacenters:"); sb.append(datacenters + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (server != null) { sb.append("server:"); sb.append(server + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}