package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VSpherePlatformTopologyBuilder extends VSpherePlatformTopologyFluent<VSpherePlatformTopologyBuilder> implements VisitableBuilder<VSpherePlatformTopology,VSpherePlatformTopologyBuilder>{
  public VSpherePlatformTopologyBuilder() {
    this(false);
  }
  public VSpherePlatformTopologyBuilder(Boolean validationEnabled) {
    this(new VSpherePlatformTopology(), validationEnabled);
  }
  public VSpherePlatformTopologyBuilder(VSpherePlatformTopologyFluent<?> fluent) {
    this(fluent, false);
  }
  public VSpherePlatformTopologyBuilder(VSpherePlatformTopologyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VSpherePlatformTopology(), validationEnabled);
  }
  public VSpherePlatformTopologyBuilder(VSpherePlatformTopologyFluent<?> fluent,VSpherePlatformTopology instance) {
    this(fluent, instance, false);
  }
  public VSpherePlatformTopologyBuilder(VSpherePlatformTopologyFluent<?> fluent,VSpherePlatformTopology instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VSpherePlatformTopology());

    if (instance != null) {
      fluent.withComputeCluster(instance.getComputeCluster());
      fluent.withDatacenter(instance.getDatacenter());
      fluent.withDatastore(instance.getDatastore());
      fluent.withFolder(instance.getFolder());
      fluent.withNetworks(instance.getNetworks());
      fluent.withResourcePool(instance.getResourcePool());
      fluent.withComputeCluster(instance.getComputeCluster());
      fluent.withDatacenter(instance.getDatacenter());
      fluent.withDatastore(instance.getDatastore());
      fluent.withFolder(instance.getFolder());
      fluent.withNetworks(instance.getNetworks());
      fluent.withResourcePool(instance.getResourcePool());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VSpherePlatformTopologyBuilder(VSpherePlatformTopology instance) {
    this(instance,false);
  }
  public VSpherePlatformTopologyBuilder(VSpherePlatformTopology instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VSpherePlatformTopology());

    if (instance != null) {
      this.withComputeCluster(instance.getComputeCluster());
      this.withDatacenter(instance.getDatacenter());
      this.withDatastore(instance.getDatastore());
      this.withFolder(instance.getFolder());
      this.withNetworks(instance.getNetworks());
      this.withResourcePool(instance.getResourcePool());
      this.withComputeCluster(instance.getComputeCluster());
      this.withDatacenter(instance.getDatacenter());
      this.withDatastore(instance.getDatastore());
      this.withFolder(instance.getFolder());
      this.withNetworks(instance.getNetworks());
      this.withResourcePool(instance.getResourcePool());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VSpherePlatformTopologyFluent<?> fluent;
  Boolean validationEnabled;
  public VSpherePlatformTopology build() {
    VSpherePlatformTopology buildable = new VSpherePlatformTopology(fluent.getComputeCluster(),fluent.getDatacenter(),fluent.getDatastore(),fluent.getFolder(),fluent.getNetworks(),fluent.getResourcePool());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}