package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VSpherePlatformNodeNetworkingSpecBuilder extends VSpherePlatformNodeNetworkingSpecFluent<VSpherePlatformNodeNetworkingSpecBuilder> implements VisitableBuilder<VSpherePlatformNodeNetworkingSpec,VSpherePlatformNodeNetworkingSpecBuilder>{
  public VSpherePlatformNodeNetworkingSpecBuilder() {
    this(false);
  }
  public VSpherePlatformNodeNetworkingSpecBuilder(Boolean validationEnabled) {
    this(new VSpherePlatformNodeNetworkingSpec(), validationEnabled);
  }
  public VSpherePlatformNodeNetworkingSpecBuilder(VSpherePlatformNodeNetworkingSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public VSpherePlatformNodeNetworkingSpecBuilder(VSpherePlatformNodeNetworkingSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VSpherePlatformNodeNetworkingSpec(), validationEnabled);
  }
  public VSpherePlatformNodeNetworkingSpecBuilder(VSpherePlatformNodeNetworkingSpecFluent<?> fluent,VSpherePlatformNodeNetworkingSpec instance) {
    this(fluent, instance, false);
  }
  public VSpherePlatformNodeNetworkingSpecBuilder(VSpherePlatformNodeNetworkingSpecFluent<?> fluent,VSpherePlatformNodeNetworkingSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VSpherePlatformNodeNetworkingSpec());

    if (instance != null) {
      fluent.withExcludeNetworkSubnetCidr(instance.getExcludeNetworkSubnetCidr());
      fluent.withNetwork(instance.getNetwork());
      fluent.withNetworkSubnetCidr(instance.getNetworkSubnetCidr());
      fluent.withExcludeNetworkSubnetCidr(instance.getExcludeNetworkSubnetCidr());
      fluent.withNetwork(instance.getNetwork());
      fluent.withNetworkSubnetCidr(instance.getNetworkSubnetCidr());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VSpherePlatformNodeNetworkingSpecBuilder(VSpherePlatformNodeNetworkingSpec instance) {
    this(instance,false);
  }
  public VSpherePlatformNodeNetworkingSpecBuilder(VSpherePlatformNodeNetworkingSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VSpherePlatformNodeNetworkingSpec());

    if (instance != null) {
      this.withExcludeNetworkSubnetCidr(instance.getExcludeNetworkSubnetCidr());
      this.withNetwork(instance.getNetwork());
      this.withNetworkSubnetCidr(instance.getNetworkSubnetCidr());
      this.withExcludeNetworkSubnetCidr(instance.getExcludeNetworkSubnetCidr());
      this.withNetwork(instance.getNetwork());
      this.withNetworkSubnetCidr(instance.getNetworkSubnetCidr());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VSpherePlatformNodeNetworkingSpecFluent<?> fluent;
  Boolean validationEnabled;
  public VSpherePlatformNodeNetworkingSpec build() {
    VSpherePlatformNodeNetworkingSpec buildable = new VSpherePlatformNodeNetworkingSpec(fluent.getExcludeNetworkSubnetCidr(),fluent.getNetwork(),fluent.getNetworkSubnetCidr());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}