package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TLSSecurityProfileBuilder extends TLSSecurityProfileFluent<TLSSecurityProfileBuilder> implements VisitableBuilder<TLSSecurityProfile,TLSSecurityProfileBuilder>{
  public TLSSecurityProfileBuilder() {
    this(false);
  }
  public TLSSecurityProfileBuilder(Boolean validationEnabled) {
    this(new TLSSecurityProfile(), validationEnabled);
  }
  public TLSSecurityProfileBuilder(TLSSecurityProfileFluent<?> fluent) {
    this(fluent, false);
  }
  public TLSSecurityProfileBuilder(TLSSecurityProfileFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TLSSecurityProfile(), validationEnabled);
  }
  public TLSSecurityProfileBuilder(TLSSecurityProfileFluent<?> fluent,TLSSecurityProfile instance) {
    this(fluent, instance, false);
  }
  public TLSSecurityProfileBuilder(TLSSecurityProfileFluent<?> fluent,TLSSecurityProfile instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TLSSecurityProfile());

    if (instance != null) {
      fluent.withCustom(instance.getCustom());
      fluent.withIntermediate(instance.getIntermediate());
      fluent.withModern(instance.getModern());
      fluent.withOld(instance.getOld());
      fluent.withType(instance.getType());
      fluent.withCustom(instance.getCustom());
      fluent.withIntermediate(instance.getIntermediate());
      fluent.withModern(instance.getModern());
      fluent.withOld(instance.getOld());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TLSSecurityProfileBuilder(TLSSecurityProfile instance) {
    this(instance,false);
  }
  public TLSSecurityProfileBuilder(TLSSecurityProfile instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TLSSecurityProfile());

    if (instance != null) {
      this.withCustom(instance.getCustom());
      this.withIntermediate(instance.getIntermediate());
      this.withModern(instance.getModern());
      this.withOld(instance.getOld());
      this.withType(instance.getType());
      this.withCustom(instance.getCustom());
      this.withIntermediate(instance.getIntermediate());
      this.withModern(instance.getModern());
      this.withOld(instance.getOld());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TLSSecurityProfileFluent<?> fluent;
  Boolean validationEnabled;
  public TLSSecurityProfile build() {
    TLSSecurityProfile buildable = new TLSSecurityProfile(fluent.buildCustom(),fluent.buildIntermediate(),fluent.buildModern(),fluent.buildOld(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}