package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SchedulerSpecFluent<A extends SchedulerSpecFluent<A>> extends BaseFluent<A>{
  public SchedulerSpecFluent() {
  }
  public SchedulerSpecFluent(SchedulerSpec instance) {
    instance = (instance != null ? instance : new SchedulerSpec());

    if (instance != null) {
      this.withDefaultNodeSelector(instance.getDefaultNodeSelector());
      this.withMastersSchedulable(instance.getMastersSchedulable());
      this.withPolicy(instance.getPolicy());
      this.withProfile(instance.getProfile());
      this.withDefaultNodeSelector(instance.getDefaultNodeSelector());
      this.withMastersSchedulable(instance.getMastersSchedulable());
      this.withPolicy(instance.getPolicy());
      this.withProfile(instance.getProfile());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String defaultNodeSelector;
  private Boolean mastersSchedulable;
  private ConfigMapNameReferenceBuilder policy;
  private String profile;
  private Map<String,Object> additionalProperties;
  public String getDefaultNodeSelector() {
    return this.defaultNodeSelector;
  }
  public A withDefaultNodeSelector(String defaultNodeSelector) {
    this.defaultNodeSelector=defaultNodeSelector; return (A) this;
  }
  public boolean hasDefaultNodeSelector() {
    return this.defaultNodeSelector != null;
  }
  public Boolean getMastersSchedulable() {
    return this.mastersSchedulable;
  }
  public A withMastersSchedulable(Boolean mastersSchedulable) {
    this.mastersSchedulable=mastersSchedulable; return (A) this;
  }
  public boolean hasMastersSchedulable() {
    return this.mastersSchedulable != null;
  }
  public ConfigMapNameReference buildPolicy() {
    return this.policy!=null ?this.policy.build():null;
  }
  public A withPolicy(ConfigMapNameReference policy) {
    _visitables.get("policy").remove(this.policy);
    if (policy!=null){ this.policy= new ConfigMapNameReferenceBuilder(policy); _visitables.get("policy").add(this.policy);} else { this.policy = null; _visitables.get("policy").remove(this.policy); } return (A) this;
  }
  public boolean hasPolicy() {
    return this.policy != null;
  }
  public A withNewPolicy(String name) {
    return (A)withPolicy(new ConfigMapNameReference(name));
  }
  public PolicyNested<A> withNewPolicy() {
    return new PolicyNested(null);
  }
  public PolicyNested<A> withNewPolicyLike(ConfigMapNameReference item) {
    return new PolicyNested(item);
  }
  public PolicyNested<A> editPolicy() {
    return withNewPolicyLike(java.util.Optional.ofNullable(buildPolicy()).orElse(null));
  }
  public PolicyNested<A> editOrNewPolicy() {
    return withNewPolicyLike(java.util.Optional.ofNullable(buildPolicy()).orElse(new ConfigMapNameReferenceBuilder().build()));
  }
  public PolicyNested<A> editOrNewPolicyLike(ConfigMapNameReference item) {
    return withNewPolicyLike(java.util.Optional.ofNullable(buildPolicy()).orElse(item));
  }
  public String getProfile() {
    return this.profile;
  }
  public A withProfile(String profile) {
    this.profile=profile; return (A) this;
  }
  public boolean hasProfile() {
    return this.profile != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SchedulerSpecFluent that = (SchedulerSpecFluent) o;
    if (!java.util.Objects.equals(defaultNodeSelector, that.defaultNodeSelector)) return false;

    if (!java.util.Objects.equals(mastersSchedulable, that.mastersSchedulable)) return false;

    if (!java.util.Objects.equals(policy, that.policy)) return false;

    if (!java.util.Objects.equals(profile, that.profile)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(defaultNodeSelector,  mastersSchedulable,  policy,  profile,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (defaultNodeSelector != null) { sb.append("defaultNodeSelector:"); sb.append(defaultNodeSelector + ","); }
    if (mastersSchedulable != null) { sb.append("mastersSchedulable:"); sb.append(mastersSchedulable + ","); }
    if (policy != null) { sb.append("policy:"); sb.append(policy + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withMastersSchedulable() {
    return withMastersSchedulable(true);
  }
  public class PolicyNested<N> extends ConfigMapNameReferenceFluent<PolicyNested<N>> implements Nested<N>{
    PolicyNested(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    ConfigMapNameReferenceBuilder builder;
    public N and() {
      return (N) SchedulerSpecFluent.this.withPolicy(builder.build());
    }
    public N endPolicy() {
      return and();
    }
    
  }
  
}