package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RepositoryDigestMirrorsBuilder extends RepositoryDigestMirrorsFluent<RepositoryDigestMirrorsBuilder> implements VisitableBuilder<RepositoryDigestMirrors,RepositoryDigestMirrorsBuilder>{
  public RepositoryDigestMirrorsBuilder() {
    this(false);
  }
  public RepositoryDigestMirrorsBuilder(Boolean validationEnabled) {
    this(new RepositoryDigestMirrors(), validationEnabled);
  }
  public RepositoryDigestMirrorsBuilder(RepositoryDigestMirrorsFluent<?> fluent) {
    this(fluent, false);
  }
  public RepositoryDigestMirrorsBuilder(RepositoryDigestMirrorsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RepositoryDigestMirrors(), validationEnabled);
  }
  public RepositoryDigestMirrorsBuilder(RepositoryDigestMirrorsFluent<?> fluent,RepositoryDigestMirrors instance) {
    this(fluent, instance, false);
  }
  public RepositoryDigestMirrorsBuilder(RepositoryDigestMirrorsFluent<?> fluent,RepositoryDigestMirrors instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RepositoryDigestMirrors());

    if (instance != null) {
      fluent.withAllowMirrorByTags(instance.getAllowMirrorByTags());
      fluent.withMirrors(instance.getMirrors());
      fluent.withSource(instance.getSource());
      fluent.withAllowMirrorByTags(instance.getAllowMirrorByTags());
      fluent.withMirrors(instance.getMirrors());
      fluent.withSource(instance.getSource());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RepositoryDigestMirrorsBuilder(RepositoryDigestMirrors instance) {
    this(instance,false);
  }
  public RepositoryDigestMirrorsBuilder(RepositoryDigestMirrors instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RepositoryDigestMirrors());

    if (instance != null) {
      this.withAllowMirrorByTags(instance.getAllowMirrorByTags());
      this.withMirrors(instance.getMirrors());
      this.withSource(instance.getSource());
      this.withAllowMirrorByTags(instance.getAllowMirrorByTags());
      this.withMirrors(instance.getMirrors());
      this.withSource(instance.getSource());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RepositoryDigestMirrorsFluent<?> fluent;
  Boolean validationEnabled;
  public RepositoryDigestMirrors build() {
    RepositoryDigestMirrors buildable = new RepositoryDigestMirrors(fluent.getAllowMirrorByTags(),fluent.getMirrors(),fluent.getSource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}