package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PowerVSPlatformStatusBuilder extends PowerVSPlatformStatusFluent<PowerVSPlatformStatusBuilder> implements VisitableBuilder<PowerVSPlatformStatus,PowerVSPlatformStatusBuilder>{
  public PowerVSPlatformStatusBuilder() {
    this(false);
  }
  public PowerVSPlatformStatusBuilder(Boolean validationEnabled) {
    this(new PowerVSPlatformStatus(), validationEnabled);
  }
  public PowerVSPlatformStatusBuilder(PowerVSPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PowerVSPlatformStatusBuilder(PowerVSPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PowerVSPlatformStatus(), validationEnabled);
  }
  public PowerVSPlatformStatusBuilder(PowerVSPlatformStatusFluent<?> fluent,PowerVSPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public PowerVSPlatformStatusBuilder(PowerVSPlatformStatusFluent<?> fluent,PowerVSPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PowerVSPlatformStatus());

    if (instance != null) {
      fluent.withCisInstanceCRN(instance.getCisInstanceCRN());
      fluent.withDnsInstanceCRN(instance.getDnsInstanceCRN());
      fluent.withRegion(instance.getRegion());
      fluent.withResourceGroup(instance.getResourceGroup());
      fluent.withServiceEndpoints(instance.getServiceEndpoints());
      fluent.withZone(instance.getZone());
      fluent.withCisInstanceCRN(instance.getCisInstanceCRN());
      fluent.withDnsInstanceCRN(instance.getDnsInstanceCRN());
      fluent.withRegion(instance.getRegion());
      fluent.withResourceGroup(instance.getResourceGroup());
      fluent.withServiceEndpoints(instance.getServiceEndpoints());
      fluent.withZone(instance.getZone());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PowerVSPlatformStatusBuilder(PowerVSPlatformStatus instance) {
    this(instance,false);
  }
  public PowerVSPlatformStatusBuilder(PowerVSPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PowerVSPlatformStatus());

    if (instance != null) {
      this.withCisInstanceCRN(instance.getCisInstanceCRN());
      this.withDnsInstanceCRN(instance.getDnsInstanceCRN());
      this.withRegion(instance.getRegion());
      this.withResourceGroup(instance.getResourceGroup());
      this.withServiceEndpoints(instance.getServiceEndpoints());
      this.withZone(instance.getZone());
      this.withCisInstanceCRN(instance.getCisInstanceCRN());
      this.withDnsInstanceCRN(instance.getDnsInstanceCRN());
      this.withRegion(instance.getRegion());
      this.withResourceGroup(instance.getResourceGroup());
      this.withServiceEndpoints(instance.getServiceEndpoints());
      this.withZone(instance.getZone());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PowerVSPlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PowerVSPlatformStatus build() {
    PowerVSPlatformStatus buildable = new PowerVSPlatformStatus(fluent.getCisInstanceCRN(),fluent.getDnsInstanceCRN(),fluent.getRegion(),fluent.getResourceGroup(),fluent.buildServiceEndpoints(),fluent.getZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}