package io.fabric8.openshift.api.model.config.v1;

import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlatformStatusFluent<A extends PlatformStatusFluent<A>> extends BaseFluent<A>{
  public PlatformStatusFluent() {
  }
  public PlatformStatusFluent(PlatformStatus instance) {
    instance = (instance != null ? instance : new PlatformStatus());

    if (instance != null) {
      this.withAlibabaCloud(instance.getAlibabaCloud());
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withBaremetal(instance.getBaremetal());
      this.withEquinixMetal(instance.getEquinixMetal());
      this.withExternal(instance.getExternal());
      this.withGcp(instance.getGcp());
      this.withIbmcloud(instance.getIbmcloud());
      this.withKubevirt(instance.getKubevirt());
      this.withNutanix(instance.getNutanix());
      this.withOpenstack(instance.getOpenstack());
      this.withOvirt(instance.getOvirt());
      this.withPowervs(instance.getPowervs());
      this.withType(instance.getType());
      this.withVsphere(instance.getVsphere());
      this.withAlibabaCloud(instance.getAlibabaCloud());
      this.withAws(instance.getAws());
      this.withAzure(instance.getAzure());
      this.withBaremetal(instance.getBaremetal());
      this.withEquinixMetal(instance.getEquinixMetal());
      this.withExternal(instance.getExternal());
      this.withGcp(instance.getGcp());
      this.withIbmcloud(instance.getIbmcloud());
      this.withKubevirt(instance.getKubevirt());
      this.withNutanix(instance.getNutanix());
      this.withOpenstack(instance.getOpenstack());
      this.withOvirt(instance.getOvirt());
      this.withPowervs(instance.getPowervs());
      this.withType(instance.getType());
      this.withVsphere(instance.getVsphere());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private AlibabaCloudPlatformStatusBuilder alibabaCloud;
  private AWSPlatformStatusBuilder aws;
  private AzurePlatformStatusBuilder azure;
  private BareMetalPlatformStatusBuilder baremetal;
  private EquinixMetalPlatformStatusBuilder equinixMetal;
  private ExternalPlatformStatusBuilder external;
  private GCPPlatformStatusBuilder gcp;
  private IBMCloudPlatformStatusBuilder ibmcloud;
  private KubevirtPlatformStatusBuilder kubevirt;
  private NutanixPlatformStatusBuilder nutanix;
  private OpenStackPlatformStatusBuilder openstack;
  private OvirtPlatformStatusBuilder ovirt;
  private PowerVSPlatformStatusBuilder powervs;
  private String type;
  private VSpherePlatformStatusBuilder vsphere;
  private Map<String,Object> additionalProperties;
  public AlibabaCloudPlatformStatus buildAlibabaCloud() {
    return this.alibabaCloud!=null ?this.alibabaCloud.build():null;
  }
  public A withAlibabaCloud(AlibabaCloudPlatformStatus alibabaCloud) {
    _visitables.get("alibabaCloud").remove(this.alibabaCloud);
    if (alibabaCloud!=null){ this.alibabaCloud= new AlibabaCloudPlatformStatusBuilder(alibabaCloud); _visitables.get("alibabaCloud").add(this.alibabaCloud);} else { this.alibabaCloud = null; _visitables.get("alibabaCloud").remove(this.alibabaCloud); } return (A) this;
  }
  public boolean hasAlibabaCloud() {
    return this.alibabaCloud != null;
  }
  public AlibabaCloudNested<A> withNewAlibabaCloud() {
    return new AlibabaCloudNested(null);
  }
  public AlibabaCloudNested<A> withNewAlibabaCloudLike(AlibabaCloudPlatformStatus item) {
    return new AlibabaCloudNested(item);
  }
  public AlibabaCloudNested<A> editAlibabaCloud() {
    return withNewAlibabaCloudLike(java.util.Optional.ofNullable(buildAlibabaCloud()).orElse(null));
  }
  public AlibabaCloudNested<A> editOrNewAlibabaCloud() {
    return withNewAlibabaCloudLike(java.util.Optional.ofNullable(buildAlibabaCloud()).orElse(new AlibabaCloudPlatformStatusBuilder().build()));
  }
  public AlibabaCloudNested<A> editOrNewAlibabaCloudLike(AlibabaCloudPlatformStatus item) {
    return withNewAlibabaCloudLike(java.util.Optional.ofNullable(buildAlibabaCloud()).orElse(item));
  }
  public AWSPlatformStatus buildAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public A withAws(AWSPlatformStatus aws) {
    _visitables.get("aws").remove(this.aws);
    if (aws!=null){ this.aws= new AWSPlatformStatusBuilder(aws); _visitables.get("aws").add(this.aws);} else { this.aws = null; _visitables.get("aws").remove(this.aws); } return (A) this;
  }
  public boolean hasAws() {
    return this.aws != null;
  }
  public AwsNested<A> withNewAws() {
    return new AwsNested(null);
  }
  public AwsNested<A> withNewAwsLike(AWSPlatformStatus item) {
    return new AwsNested(item);
  }
  public AwsNested<A> editAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(null));
  }
  public AwsNested<A> editOrNewAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(new AWSPlatformStatusBuilder().build()));
  }
  public AwsNested<A> editOrNewAwsLike(AWSPlatformStatus item) {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(item));
  }
  public AzurePlatformStatus buildAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public A withAzure(AzurePlatformStatus azure) {
    _visitables.get("azure").remove(this.azure);
    if (azure!=null){ this.azure= new AzurePlatformStatusBuilder(azure); _visitables.get("azure").add(this.azure);} else { this.azure = null; _visitables.get("azure").remove(this.azure); } return (A) this;
  }
  public boolean hasAzure() {
    return this.azure != null;
  }
  public AzureNested<A> withNewAzure() {
    return new AzureNested(null);
  }
  public AzureNested<A> withNewAzureLike(AzurePlatformStatus item) {
    return new AzureNested(item);
  }
  public AzureNested<A> editAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(null));
  }
  public AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(new AzurePlatformStatusBuilder().build()));
  }
  public AzureNested<A> editOrNewAzureLike(AzurePlatformStatus item) {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(item));
  }
  public BareMetalPlatformStatus buildBaremetal() {
    return this.baremetal!=null ?this.baremetal.build():null;
  }
  public A withBaremetal(BareMetalPlatformStatus baremetal) {
    _visitables.get("baremetal").remove(this.baremetal);
    if (baremetal!=null){ this.baremetal= new BareMetalPlatformStatusBuilder(baremetal); _visitables.get("baremetal").add(this.baremetal);} else { this.baremetal = null; _visitables.get("baremetal").remove(this.baremetal); } return (A) this;
  }
  public boolean hasBaremetal() {
    return this.baremetal != null;
  }
  public BaremetalNested<A> withNewBaremetal() {
    return new BaremetalNested(null);
  }
  public BaremetalNested<A> withNewBaremetalLike(BareMetalPlatformStatus item) {
    return new BaremetalNested(item);
  }
  public BaremetalNested<A> editBaremetal() {
    return withNewBaremetalLike(java.util.Optional.ofNullable(buildBaremetal()).orElse(null));
  }
  public BaremetalNested<A> editOrNewBaremetal() {
    return withNewBaremetalLike(java.util.Optional.ofNullable(buildBaremetal()).orElse(new BareMetalPlatformStatusBuilder().build()));
  }
  public BaremetalNested<A> editOrNewBaremetalLike(BareMetalPlatformStatus item) {
    return withNewBaremetalLike(java.util.Optional.ofNullable(buildBaremetal()).orElse(item));
  }
  public EquinixMetalPlatformStatus buildEquinixMetal() {
    return this.equinixMetal!=null ?this.equinixMetal.build():null;
  }
  public A withEquinixMetal(EquinixMetalPlatformStatus equinixMetal) {
    _visitables.get("equinixMetal").remove(this.equinixMetal);
    if (equinixMetal!=null){ this.equinixMetal= new EquinixMetalPlatformStatusBuilder(equinixMetal); _visitables.get("equinixMetal").add(this.equinixMetal);} else { this.equinixMetal = null; _visitables.get("equinixMetal").remove(this.equinixMetal); } return (A) this;
  }
  public boolean hasEquinixMetal() {
    return this.equinixMetal != null;
  }
  public A withNewEquinixMetal(String apiServerInternalIP,String ingressIP) {
    return (A)withEquinixMetal(new EquinixMetalPlatformStatus(apiServerInternalIP, ingressIP));
  }
  public EquinixMetalNested<A> withNewEquinixMetal() {
    return new EquinixMetalNested(null);
  }
  public EquinixMetalNested<A> withNewEquinixMetalLike(EquinixMetalPlatformStatus item) {
    return new EquinixMetalNested(item);
  }
  public EquinixMetalNested<A> editEquinixMetal() {
    return withNewEquinixMetalLike(java.util.Optional.ofNullable(buildEquinixMetal()).orElse(null));
  }
  public EquinixMetalNested<A> editOrNewEquinixMetal() {
    return withNewEquinixMetalLike(java.util.Optional.ofNullable(buildEquinixMetal()).orElse(new EquinixMetalPlatformStatusBuilder().build()));
  }
  public EquinixMetalNested<A> editOrNewEquinixMetalLike(EquinixMetalPlatformStatus item) {
    return withNewEquinixMetalLike(java.util.Optional.ofNullable(buildEquinixMetal()).orElse(item));
  }
  public ExternalPlatformStatus buildExternal() {
    return this.external!=null ?this.external.build():null;
  }
  public A withExternal(ExternalPlatformStatus external) {
    _visitables.get("external").remove(this.external);
    if (external!=null){ this.external= new ExternalPlatformStatusBuilder(external); _visitables.get("external").add(this.external);} else { this.external = null; _visitables.get("external").remove(this.external); } return (A) this;
  }
  public boolean hasExternal() {
    return this.external != null;
  }
  public ExternalNested<A> withNewExternal() {
    return new ExternalNested(null);
  }
  public ExternalNested<A> withNewExternalLike(ExternalPlatformStatus item) {
    return new ExternalNested(item);
  }
  public ExternalNested<A> editExternal() {
    return withNewExternalLike(java.util.Optional.ofNullable(buildExternal()).orElse(null));
  }
  public ExternalNested<A> editOrNewExternal() {
    return withNewExternalLike(java.util.Optional.ofNullable(buildExternal()).orElse(new ExternalPlatformStatusBuilder().build()));
  }
  public ExternalNested<A> editOrNewExternalLike(ExternalPlatformStatus item) {
    return withNewExternalLike(java.util.Optional.ofNullable(buildExternal()).orElse(item));
  }
  public GCPPlatformStatus buildGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public A withGcp(GCPPlatformStatus gcp) {
    _visitables.get("gcp").remove(this.gcp);
    if (gcp!=null){ this.gcp= new GCPPlatformStatusBuilder(gcp); _visitables.get("gcp").add(this.gcp);} else { this.gcp = null; _visitables.get("gcp").remove(this.gcp); } return (A) this;
  }
  public boolean hasGcp() {
    return this.gcp != null;
  }
  public A withNewGcp(String projectID,String region) {
    return (A)withGcp(new GCPPlatformStatus(projectID, region));
  }
  public GcpNested<A> withNewGcp() {
    return new GcpNested(null);
  }
  public GcpNested<A> withNewGcpLike(GCPPlatformStatus item) {
    return new GcpNested(item);
  }
  public GcpNested<A> editGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(null));
  }
  public GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(new GCPPlatformStatusBuilder().build()));
  }
  public GcpNested<A> editOrNewGcpLike(GCPPlatformStatus item) {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(item));
  }
  public IBMCloudPlatformStatus buildIbmcloud() {
    return this.ibmcloud!=null ?this.ibmcloud.build():null;
  }
  public A withIbmcloud(IBMCloudPlatformStatus ibmcloud) {
    _visitables.get("ibmcloud").remove(this.ibmcloud);
    if (ibmcloud!=null){ this.ibmcloud= new IBMCloudPlatformStatusBuilder(ibmcloud); _visitables.get("ibmcloud").add(this.ibmcloud);} else { this.ibmcloud = null; _visitables.get("ibmcloud").remove(this.ibmcloud); } return (A) this;
  }
  public boolean hasIbmcloud() {
    return this.ibmcloud != null;
  }
  public A withNewIbmcloud(String cisInstanceCRN,String dnsInstanceCRN,String location,String providerType,String resourceGroupName) {
    return (A)withIbmcloud(new IBMCloudPlatformStatus(cisInstanceCRN, dnsInstanceCRN, location, providerType, resourceGroupName));
  }
  public IbmcloudNested<A> withNewIbmcloud() {
    return new IbmcloudNested(null);
  }
  public IbmcloudNested<A> withNewIbmcloudLike(IBMCloudPlatformStatus item) {
    return new IbmcloudNested(item);
  }
  public IbmcloudNested<A> editIbmcloud() {
    return withNewIbmcloudLike(java.util.Optional.ofNullable(buildIbmcloud()).orElse(null));
  }
  public IbmcloudNested<A> editOrNewIbmcloud() {
    return withNewIbmcloudLike(java.util.Optional.ofNullable(buildIbmcloud()).orElse(new IBMCloudPlatformStatusBuilder().build()));
  }
  public IbmcloudNested<A> editOrNewIbmcloudLike(IBMCloudPlatformStatus item) {
    return withNewIbmcloudLike(java.util.Optional.ofNullable(buildIbmcloud()).orElse(item));
  }
  public KubevirtPlatformStatus buildKubevirt() {
    return this.kubevirt!=null ?this.kubevirt.build():null;
  }
  public A withKubevirt(KubevirtPlatformStatus kubevirt) {
    _visitables.get("kubevirt").remove(this.kubevirt);
    if (kubevirt!=null){ this.kubevirt= new KubevirtPlatformStatusBuilder(kubevirt); _visitables.get("kubevirt").add(this.kubevirt);} else { this.kubevirt = null; _visitables.get("kubevirt").remove(this.kubevirt); } return (A) this;
  }
  public boolean hasKubevirt() {
    return this.kubevirt != null;
  }
  public A withNewKubevirt(String apiServerInternalIP,String ingressIP) {
    return (A)withKubevirt(new KubevirtPlatformStatus(apiServerInternalIP, ingressIP));
  }
  public KubevirtNested<A> withNewKubevirt() {
    return new KubevirtNested(null);
  }
  public KubevirtNested<A> withNewKubevirtLike(KubevirtPlatformStatus item) {
    return new KubevirtNested(item);
  }
  public KubevirtNested<A> editKubevirt() {
    return withNewKubevirtLike(java.util.Optional.ofNullable(buildKubevirt()).orElse(null));
  }
  public KubevirtNested<A> editOrNewKubevirt() {
    return withNewKubevirtLike(java.util.Optional.ofNullable(buildKubevirt()).orElse(new KubevirtPlatformStatusBuilder().build()));
  }
  public KubevirtNested<A> editOrNewKubevirtLike(KubevirtPlatformStatus item) {
    return withNewKubevirtLike(java.util.Optional.ofNullable(buildKubevirt()).orElse(item));
  }
  public NutanixPlatformStatus buildNutanix() {
    return this.nutanix!=null ?this.nutanix.build():null;
  }
  public A withNutanix(NutanixPlatformStatus nutanix) {
    _visitables.get("nutanix").remove(this.nutanix);
    if (nutanix!=null){ this.nutanix= new NutanixPlatformStatusBuilder(nutanix); _visitables.get("nutanix").add(this.nutanix);} else { this.nutanix = null; _visitables.get("nutanix").remove(this.nutanix); } return (A) this;
  }
  public boolean hasNutanix() {
    return this.nutanix != null;
  }
  public NutanixNested<A> withNewNutanix() {
    return new NutanixNested(null);
  }
  public NutanixNested<A> withNewNutanixLike(NutanixPlatformStatus item) {
    return new NutanixNested(item);
  }
  public NutanixNested<A> editNutanix() {
    return withNewNutanixLike(java.util.Optional.ofNullable(buildNutanix()).orElse(null));
  }
  public NutanixNested<A> editOrNewNutanix() {
    return withNewNutanixLike(java.util.Optional.ofNullable(buildNutanix()).orElse(new NutanixPlatformStatusBuilder().build()));
  }
  public NutanixNested<A> editOrNewNutanixLike(NutanixPlatformStatus item) {
    return withNewNutanixLike(java.util.Optional.ofNullable(buildNutanix()).orElse(item));
  }
  public OpenStackPlatformStatus buildOpenstack() {
    return this.openstack!=null ?this.openstack.build():null;
  }
  public A withOpenstack(OpenStackPlatformStatus openstack) {
    _visitables.get("openstack").remove(this.openstack);
    if (openstack!=null){ this.openstack= new OpenStackPlatformStatusBuilder(openstack); _visitables.get("openstack").add(this.openstack);} else { this.openstack = null; _visitables.get("openstack").remove(this.openstack); } return (A) this;
  }
  public boolean hasOpenstack() {
    return this.openstack != null;
  }
  public OpenstackNested<A> withNewOpenstack() {
    return new OpenstackNested(null);
  }
  public OpenstackNested<A> withNewOpenstackLike(OpenStackPlatformStatus item) {
    return new OpenstackNested(item);
  }
  public OpenstackNested<A> editOpenstack() {
    return withNewOpenstackLike(java.util.Optional.ofNullable(buildOpenstack()).orElse(null));
  }
  public OpenstackNested<A> editOrNewOpenstack() {
    return withNewOpenstackLike(java.util.Optional.ofNullable(buildOpenstack()).orElse(new OpenStackPlatformStatusBuilder().build()));
  }
  public OpenstackNested<A> editOrNewOpenstackLike(OpenStackPlatformStatus item) {
    return withNewOpenstackLike(java.util.Optional.ofNullable(buildOpenstack()).orElse(item));
  }
  public OvirtPlatformStatus buildOvirt() {
    return this.ovirt!=null ?this.ovirt.build():null;
  }
  public A withOvirt(OvirtPlatformStatus ovirt) {
    _visitables.get("ovirt").remove(this.ovirt);
    if (ovirt!=null){ this.ovirt= new OvirtPlatformStatusBuilder(ovirt); _visitables.get("ovirt").add(this.ovirt);} else { this.ovirt = null; _visitables.get("ovirt").remove(this.ovirt); } return (A) this;
  }
  public boolean hasOvirt() {
    return this.ovirt != null;
  }
  public OvirtNested<A> withNewOvirt() {
    return new OvirtNested(null);
  }
  public OvirtNested<A> withNewOvirtLike(OvirtPlatformStatus item) {
    return new OvirtNested(item);
  }
  public OvirtNested<A> editOvirt() {
    return withNewOvirtLike(java.util.Optional.ofNullable(buildOvirt()).orElse(null));
  }
  public OvirtNested<A> editOrNewOvirt() {
    return withNewOvirtLike(java.util.Optional.ofNullable(buildOvirt()).orElse(new OvirtPlatformStatusBuilder().build()));
  }
  public OvirtNested<A> editOrNewOvirtLike(OvirtPlatformStatus item) {
    return withNewOvirtLike(java.util.Optional.ofNullable(buildOvirt()).orElse(item));
  }
  public PowerVSPlatformStatus buildPowervs() {
    return this.powervs!=null ?this.powervs.build():null;
  }
  public A withPowervs(PowerVSPlatformStatus powervs) {
    _visitables.get("powervs").remove(this.powervs);
    if (powervs!=null){ this.powervs= new PowerVSPlatformStatusBuilder(powervs); _visitables.get("powervs").add(this.powervs);} else { this.powervs = null; _visitables.get("powervs").remove(this.powervs); } return (A) this;
  }
  public boolean hasPowervs() {
    return this.powervs != null;
  }
  public PowervsNested<A> withNewPowervs() {
    return new PowervsNested(null);
  }
  public PowervsNested<A> withNewPowervsLike(PowerVSPlatformStatus item) {
    return new PowervsNested(item);
  }
  public PowervsNested<A> editPowervs() {
    return withNewPowervsLike(java.util.Optional.ofNullable(buildPowervs()).orElse(null));
  }
  public PowervsNested<A> editOrNewPowervs() {
    return withNewPowervsLike(java.util.Optional.ofNullable(buildPowervs()).orElse(new PowerVSPlatformStatusBuilder().build()));
  }
  public PowervsNested<A> editOrNewPowervsLike(PowerVSPlatformStatus item) {
    return withNewPowervsLike(java.util.Optional.ofNullable(buildPowervs()).orElse(item));
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public boolean hasType() {
    return this.type != null;
  }
  public VSpherePlatformStatus buildVsphere() {
    return this.vsphere!=null ?this.vsphere.build():null;
  }
  public A withVsphere(VSpherePlatformStatus vsphere) {
    _visitables.get("vsphere").remove(this.vsphere);
    if (vsphere!=null){ this.vsphere= new VSpherePlatformStatusBuilder(vsphere); _visitables.get("vsphere").add(this.vsphere);} else { this.vsphere = null; _visitables.get("vsphere").remove(this.vsphere); } return (A) this;
  }
  public boolean hasVsphere() {
    return this.vsphere != null;
  }
  public VsphereNested<A> withNewVsphere() {
    return new VsphereNested(null);
  }
  public VsphereNested<A> withNewVsphereLike(VSpherePlatformStatus item) {
    return new VsphereNested(item);
  }
  public VsphereNested<A> editVsphere() {
    return withNewVsphereLike(java.util.Optional.ofNullable(buildVsphere()).orElse(null));
  }
  public VsphereNested<A> editOrNewVsphere() {
    return withNewVsphereLike(java.util.Optional.ofNullable(buildVsphere()).orElse(new VSpherePlatformStatusBuilder().build()));
  }
  public VsphereNested<A> editOrNewVsphereLike(VSpherePlatformStatus item) {
    return withNewVsphereLike(java.util.Optional.ofNullable(buildVsphere()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformStatusFluent that = (PlatformStatusFluent) o;
    if (!java.util.Objects.equals(alibabaCloud, that.alibabaCloud)) return false;

    if (!java.util.Objects.equals(aws, that.aws)) return false;

    if (!java.util.Objects.equals(azure, that.azure)) return false;

    if (!java.util.Objects.equals(baremetal, that.baremetal)) return false;

    if (!java.util.Objects.equals(equinixMetal, that.equinixMetal)) return false;

    if (!java.util.Objects.equals(external, that.external)) return false;

    if (!java.util.Objects.equals(gcp, that.gcp)) return false;

    if (!java.util.Objects.equals(ibmcloud, that.ibmcloud)) return false;

    if (!java.util.Objects.equals(kubevirt, that.kubevirt)) return false;

    if (!java.util.Objects.equals(nutanix, that.nutanix)) return false;

    if (!java.util.Objects.equals(openstack, that.openstack)) return false;

    if (!java.util.Objects.equals(ovirt, that.ovirt)) return false;

    if (!java.util.Objects.equals(powervs, that.powervs)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(vsphere, that.vsphere)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(alibabaCloud,  aws,  azure,  baremetal,  equinixMetal,  external,  gcp,  ibmcloud,  kubevirt,  nutanix,  openstack,  ovirt,  powervs,  type,  vsphere,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alibabaCloud != null) { sb.append("alibabaCloud:"); sb.append(alibabaCloud + ","); }
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (baremetal != null) { sb.append("baremetal:"); sb.append(baremetal + ","); }
    if (equinixMetal != null) { sb.append("equinixMetal:"); sb.append(equinixMetal + ","); }
    if (external != null) { sb.append("external:"); sb.append(external + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (ibmcloud != null) { sb.append("ibmcloud:"); sb.append(ibmcloud + ","); }
    if (kubevirt != null) { sb.append("kubevirt:"); sb.append(kubevirt + ","); }
    if (nutanix != null) { sb.append("nutanix:"); sb.append(nutanix + ","); }
    if (openstack != null) { sb.append("openstack:"); sb.append(openstack + ","); }
    if (ovirt != null) { sb.append("ovirt:"); sb.append(ovirt + ","); }
    if (powervs != null) { sb.append("powervs:"); sb.append(powervs + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (vsphere != null) { sb.append("vsphere:"); sb.append(vsphere + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AlibabaCloudNested<N> extends AlibabaCloudPlatformStatusFluent<AlibabaCloudNested<N>> implements Nested<N>{
    AlibabaCloudNested(AlibabaCloudPlatformStatus item) {
      this.builder = new AlibabaCloudPlatformStatusBuilder(this, item);
    }
    AlibabaCloudPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withAlibabaCloud(builder.build());
    }
    public N endAlibabaCloud() {
      return and();
    }
    
  }
  public class AwsNested<N> extends AWSPlatformStatusFluent<AwsNested<N>> implements Nested<N>{
    AwsNested(AWSPlatformStatus item) {
      this.builder = new AWSPlatformStatusBuilder(this, item);
    }
    AWSPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withAws(builder.build());
    }
    public N endAws() {
      return and();
    }
    
  }
  public class AzureNested<N> extends AzurePlatformStatusFluent<AzureNested<N>> implements Nested<N>{
    AzureNested(AzurePlatformStatus item) {
      this.builder = new AzurePlatformStatusBuilder(this, item);
    }
    AzurePlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withAzure(builder.build());
    }
    public N endAzure() {
      return and();
    }
    
  }
  public class BaremetalNested<N> extends BareMetalPlatformStatusFluent<BaremetalNested<N>> implements Nested<N>{
    BaremetalNested(BareMetalPlatformStatus item) {
      this.builder = new BareMetalPlatformStatusBuilder(this, item);
    }
    BareMetalPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withBaremetal(builder.build());
    }
    public N endBaremetal() {
      return and();
    }
    
  }
  public class EquinixMetalNested<N> extends EquinixMetalPlatformStatusFluent<EquinixMetalNested<N>> implements Nested<N>{
    EquinixMetalNested(EquinixMetalPlatformStatus item) {
      this.builder = new EquinixMetalPlatformStatusBuilder(this, item);
    }
    EquinixMetalPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withEquinixMetal(builder.build());
    }
    public N endEquinixMetal() {
      return and();
    }
    
  }
  public class ExternalNested<N> extends ExternalPlatformStatusFluent<ExternalNested<N>> implements Nested<N>{
    ExternalNested(ExternalPlatformStatus item) {
      this.builder = new ExternalPlatformStatusBuilder(this, item);
    }
    ExternalPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withExternal(builder.build());
    }
    public N endExternal() {
      return and();
    }
    
  }
  public class GcpNested<N> extends GCPPlatformStatusFluent<GcpNested<N>> implements Nested<N>{
    GcpNested(GCPPlatformStatus item) {
      this.builder = new GCPPlatformStatusBuilder(this, item);
    }
    GCPPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withGcp(builder.build());
    }
    public N endGcp() {
      return and();
    }
    
  }
  public class IbmcloudNested<N> extends IBMCloudPlatformStatusFluent<IbmcloudNested<N>> implements Nested<N>{
    IbmcloudNested(IBMCloudPlatformStatus item) {
      this.builder = new IBMCloudPlatformStatusBuilder(this, item);
    }
    IBMCloudPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withIbmcloud(builder.build());
    }
    public N endIbmcloud() {
      return and();
    }
    
  }
  public class KubevirtNested<N> extends KubevirtPlatformStatusFluent<KubevirtNested<N>> implements Nested<N>{
    KubevirtNested(KubevirtPlatformStatus item) {
      this.builder = new KubevirtPlatformStatusBuilder(this, item);
    }
    KubevirtPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withKubevirt(builder.build());
    }
    public N endKubevirt() {
      return and();
    }
    
  }
  public class NutanixNested<N> extends NutanixPlatformStatusFluent<NutanixNested<N>> implements Nested<N>{
    NutanixNested(NutanixPlatformStatus item) {
      this.builder = new NutanixPlatformStatusBuilder(this, item);
    }
    NutanixPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withNutanix(builder.build());
    }
    public N endNutanix() {
      return and();
    }
    
  }
  public class OpenstackNested<N> extends OpenStackPlatformStatusFluent<OpenstackNested<N>> implements Nested<N>{
    OpenstackNested(OpenStackPlatformStatus item) {
      this.builder = new OpenStackPlatformStatusBuilder(this, item);
    }
    OpenStackPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withOpenstack(builder.build());
    }
    public N endOpenstack() {
      return and();
    }
    
  }
  public class OvirtNested<N> extends OvirtPlatformStatusFluent<OvirtNested<N>> implements Nested<N>{
    OvirtNested(OvirtPlatformStatus item) {
      this.builder = new OvirtPlatformStatusBuilder(this, item);
    }
    OvirtPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withOvirt(builder.build());
    }
    public N endOvirt() {
      return and();
    }
    
  }
  public class PowervsNested<N> extends PowerVSPlatformStatusFluent<PowervsNested<N>> implements Nested<N>{
    PowervsNested(PowerVSPlatformStatus item) {
      this.builder = new PowerVSPlatformStatusBuilder(this, item);
    }
    PowerVSPlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withPowervs(builder.build());
    }
    public N endPowervs() {
      return and();
    }
    
  }
  public class VsphereNested<N> extends VSpherePlatformStatusFluent<VsphereNested<N>> implements Nested<N>{
    VsphereNested(VSpherePlatformStatus item) {
      this.builder = new VSpherePlatformStatusBuilder(this, item);
    }
    VSpherePlatformStatusBuilder builder;
    public N and() {
      return (N) PlatformStatusFluent.this.withVsphere(builder.build());
    }
    public N endVsphere() {
      return and();
    }
    
  }
  
}