package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenStackPlatformSpecBuilder extends OpenStackPlatformSpecFluent<OpenStackPlatformSpecBuilder> implements VisitableBuilder<OpenStackPlatformSpec,OpenStackPlatformSpecBuilder>{
  public OpenStackPlatformSpecBuilder() {
    this(false);
  }
  public OpenStackPlatformSpecBuilder(Boolean validationEnabled) {
    this(new OpenStackPlatformSpec(), validationEnabled);
  }
  public OpenStackPlatformSpecBuilder(OpenStackPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenStackPlatformSpecBuilder(OpenStackPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenStackPlatformSpec(), validationEnabled);
  }
  public OpenStackPlatformSpecBuilder(OpenStackPlatformSpecFluent<?> fluent,OpenStackPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public OpenStackPlatformSpecBuilder(OpenStackPlatformSpecFluent<?> fluent,OpenStackPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OpenStackPlatformSpec());

    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OpenStackPlatformSpecBuilder(OpenStackPlatformSpec instance) {
    this(instance,false);
  }
  public OpenStackPlatformSpecBuilder(OpenStackPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OpenStackPlatformSpec());

    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OpenStackPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public OpenStackPlatformSpec build() {
    OpenStackPlatformSpec buildable = new OpenStackPlatformSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}