package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NutanixPrismEndpointBuilder extends NutanixPrismEndpointFluent<NutanixPrismEndpointBuilder> implements VisitableBuilder<NutanixPrismEndpoint,NutanixPrismEndpointBuilder>{
  public NutanixPrismEndpointBuilder() {
    this(false);
  }
  public NutanixPrismEndpointBuilder(Boolean validationEnabled) {
    this(new NutanixPrismEndpoint(), validationEnabled);
  }
  public NutanixPrismEndpointBuilder(NutanixPrismEndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public NutanixPrismEndpointBuilder(NutanixPrismEndpointFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NutanixPrismEndpoint(), validationEnabled);
  }
  public NutanixPrismEndpointBuilder(NutanixPrismEndpointFluent<?> fluent,NutanixPrismEndpoint instance) {
    this(fluent, instance, false);
  }
  public NutanixPrismEndpointBuilder(NutanixPrismEndpointFluent<?> fluent,NutanixPrismEndpoint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NutanixPrismEndpoint());

    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withPort(instance.getPort());
      fluent.withAddress(instance.getAddress());
      fluent.withPort(instance.getPort());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NutanixPrismEndpointBuilder(NutanixPrismEndpoint instance) {
    this(instance,false);
  }
  public NutanixPrismEndpointBuilder(NutanixPrismEndpoint instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NutanixPrismEndpoint());

    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withPort(instance.getPort());
      this.withAddress(instance.getAddress());
      this.withPort(instance.getPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NutanixPrismEndpointFluent<?> fluent;
  Boolean validationEnabled;
  public NutanixPrismEndpoint build() {
    NutanixPrismEndpoint buildable = new NutanixPrismEndpoint(fluent.getAddress(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}