package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NutanixPlatformStatusBuilder extends NutanixPlatformStatusFluent<NutanixPlatformStatusBuilder> implements VisitableBuilder<NutanixPlatformStatus,NutanixPlatformStatusBuilder>{
  public NutanixPlatformStatusBuilder() {
    this(false);
  }
  public NutanixPlatformStatusBuilder(Boolean validationEnabled) {
    this(new NutanixPlatformStatus(), validationEnabled);
  }
  public NutanixPlatformStatusBuilder(NutanixPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NutanixPlatformStatusBuilder(NutanixPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NutanixPlatformStatus(), validationEnabled);
  }
  public NutanixPlatformStatusBuilder(NutanixPlatformStatusFluent<?> fluent,NutanixPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public NutanixPlatformStatusBuilder(NutanixPlatformStatusFluent<?> fluent,NutanixPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NutanixPlatformStatus());

    if (instance != null) {
      fluent.withApiServerInternalIP(instance.getApiServerInternalIP());
      fluent.withApiServerInternalIPs(instance.getApiServerInternalIPs());
      fluent.withIngressIP(instance.getIngressIP());
      fluent.withIngressIPs(instance.getIngressIPs());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withApiServerInternalIP(instance.getApiServerInternalIP());
      fluent.withApiServerInternalIPs(instance.getApiServerInternalIPs());
      fluent.withIngressIP(instance.getIngressIP());
      fluent.withIngressIPs(instance.getIngressIPs());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NutanixPlatformStatusBuilder(NutanixPlatformStatus instance) {
    this(instance,false);
  }
  public NutanixPlatformStatusBuilder(NutanixPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NutanixPlatformStatus());

    if (instance != null) {
      this.withApiServerInternalIP(instance.getApiServerInternalIP());
      this.withApiServerInternalIPs(instance.getApiServerInternalIPs());
      this.withIngressIP(instance.getIngressIP());
      this.withIngressIPs(instance.getIngressIPs());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withApiServerInternalIP(instance.getApiServerInternalIP());
      this.withApiServerInternalIPs(instance.getApiServerInternalIPs());
      this.withIngressIP(instance.getIngressIP());
      this.withIngressIPs(instance.getIngressIPs());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NutanixPlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public NutanixPlatformStatus build() {
    NutanixPlatformStatus buildable = new NutanixPlatformStatus(fluent.getApiServerInternalIP(),fluent.getApiServerInternalIPs(),fluent.getIngressIP(),fluent.getIngressIPs(),fluent.buildLoadBalancer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}