package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NutanixPlatformSpecBuilder extends NutanixPlatformSpecFluent<NutanixPlatformSpecBuilder> implements VisitableBuilder<NutanixPlatformSpec,NutanixPlatformSpecBuilder>{
  public NutanixPlatformSpecBuilder() {
    this(false);
  }
  public NutanixPlatformSpecBuilder(Boolean validationEnabled) {
    this(new NutanixPlatformSpec(), validationEnabled);
  }
  public NutanixPlatformSpecBuilder(NutanixPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NutanixPlatformSpecBuilder(NutanixPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NutanixPlatformSpec(), validationEnabled);
  }
  public NutanixPlatformSpecBuilder(NutanixPlatformSpecFluent<?> fluent,NutanixPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public NutanixPlatformSpecBuilder(NutanixPlatformSpecFluent<?> fluent,NutanixPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NutanixPlatformSpec());

    if (instance != null) {
      fluent.withPrismCentral(instance.getPrismCentral());
      fluent.withPrismElements(instance.getPrismElements());
      fluent.withPrismCentral(instance.getPrismCentral());
      fluent.withPrismElements(instance.getPrismElements());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NutanixPlatformSpecBuilder(NutanixPlatformSpec instance) {
    this(instance,false);
  }
  public NutanixPlatformSpecBuilder(NutanixPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NutanixPlatformSpec());

    if (instance != null) {
      this.withPrismCentral(instance.getPrismCentral());
      this.withPrismElements(instance.getPrismElements());
      this.withPrismCentral(instance.getPrismCentral());
      this.withPrismElements(instance.getPrismElements());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NutanixPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public NutanixPlatformSpec build() {
    NutanixPlatformSpec buildable = new NutanixPlatformSpec(fluent.buildPrismCentral(),fluent.buildPrismElements());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}