package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NutanixPlatformLoadBalancerBuilder extends NutanixPlatformLoadBalancerFluent<NutanixPlatformLoadBalancerBuilder> implements VisitableBuilder<NutanixPlatformLoadBalancer,NutanixPlatformLoadBalancerBuilder>{
  public NutanixPlatformLoadBalancerBuilder() {
    this(false);
  }
  public NutanixPlatformLoadBalancerBuilder(Boolean validationEnabled) {
    this(new NutanixPlatformLoadBalancer(), validationEnabled);
  }
  public NutanixPlatformLoadBalancerBuilder(NutanixPlatformLoadBalancerFluent<?> fluent) {
    this(fluent, false);
  }
  public NutanixPlatformLoadBalancerBuilder(NutanixPlatformLoadBalancerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NutanixPlatformLoadBalancer(), validationEnabled);
  }
  public NutanixPlatformLoadBalancerBuilder(NutanixPlatformLoadBalancerFluent<?> fluent,NutanixPlatformLoadBalancer instance) {
    this(fluent, instance, false);
  }
  public NutanixPlatformLoadBalancerBuilder(NutanixPlatformLoadBalancerFluent<?> fluent,NutanixPlatformLoadBalancer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NutanixPlatformLoadBalancer());

    if (instance != null) {
      fluent.withType(instance.getType());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NutanixPlatformLoadBalancerBuilder(NutanixPlatformLoadBalancer instance) {
    this(instance,false);
  }
  public NutanixPlatformLoadBalancerBuilder(NutanixPlatformLoadBalancer instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NutanixPlatformLoadBalancer());

    if (instance != null) {
      this.withType(instance.getType());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NutanixPlatformLoadBalancerFluent<?> fluent;
  Boolean validationEnabled;
  public NutanixPlatformLoadBalancer build() {
    NutanixPlatformLoadBalancer buildable = new NutanixPlatformLoadBalancer(fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}