package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ModernTLSProfileBuilder extends ModernTLSProfileFluent<ModernTLSProfileBuilder> implements VisitableBuilder<ModernTLSProfile,ModernTLSProfileBuilder>{
  public ModernTLSProfileBuilder() {
    this(false);
  }
  public ModernTLSProfileBuilder(Boolean validationEnabled) {
    this(new ModernTLSProfile(), validationEnabled);
  }
  public ModernTLSProfileBuilder(ModernTLSProfileFluent<?> fluent) {
    this(fluent, false);
  }
  public ModernTLSProfileBuilder(ModernTLSProfileFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ModernTLSProfile(), validationEnabled);
  }
  public ModernTLSProfileBuilder(ModernTLSProfileFluent<?> fluent,ModernTLSProfile instance) {
    this(fluent, instance, false);
  }
  public ModernTLSProfileBuilder(ModernTLSProfileFluent<?> fluent,ModernTLSProfile instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ModernTLSProfile());

    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ModernTLSProfileBuilder(ModernTLSProfile instance) {
    this(instance,false);
  }
  public ModernTLSProfileBuilder(ModernTLSProfile instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ModernTLSProfile());

    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ModernTLSProfileFluent<?> fluent;
  Boolean validationEnabled;
  public ModernTLSProfile build() {
    ModernTLSProfile buildable = new ModernTLSProfile();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}