package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MTUMigrationBuilder extends MTUMigrationFluent<MTUMigrationBuilder> implements VisitableBuilder<MTUMigration,MTUMigrationBuilder>{
  public MTUMigrationBuilder() {
    this(false);
  }
  public MTUMigrationBuilder(Boolean validationEnabled) {
    this(new MTUMigration(), validationEnabled);
  }
  public MTUMigrationBuilder(MTUMigrationFluent<?> fluent) {
    this(fluent, false);
  }
  public MTUMigrationBuilder(MTUMigrationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MTUMigration(), validationEnabled);
  }
  public MTUMigrationBuilder(MTUMigrationFluent<?> fluent,MTUMigration instance) {
    this(fluent, instance, false);
  }
  public MTUMigrationBuilder(MTUMigrationFluent<?> fluent,MTUMigration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MTUMigration());

    if (instance != null) {
      fluent.withMachine(instance.getMachine());
      fluent.withNetwork(instance.getNetwork());
      fluent.withMachine(instance.getMachine());
      fluent.withNetwork(instance.getNetwork());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MTUMigrationBuilder(MTUMigration instance) {
    this(instance,false);
  }
  public MTUMigrationBuilder(MTUMigration instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MTUMigration());

    if (instance != null) {
      this.withMachine(instance.getMachine());
      this.withNetwork(instance.getNetwork());
      this.withMachine(instance.getMachine());
      this.withNetwork(instance.getNetwork());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MTUMigrationFluent<?> fluent;
  Boolean validationEnabled;
  public MTUMigration build() {
    MTUMigration buildable = new MTUMigration(fluent.buildMachine(),fluent.buildNetwork());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}