package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LoadBalancerBuilder extends LoadBalancerFluent<LoadBalancerBuilder> implements VisitableBuilder<LoadBalancer,LoadBalancerBuilder>{
  public LoadBalancerBuilder() {
    this(false);
  }
  public LoadBalancerBuilder(Boolean validationEnabled) {
    this(new LoadBalancer(), validationEnabled);
  }
  public LoadBalancerBuilder(LoadBalancerFluent<?> fluent) {
    this(fluent, false);
  }
  public LoadBalancerBuilder(LoadBalancerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LoadBalancer(), validationEnabled);
  }
  public LoadBalancerBuilder(LoadBalancerFluent<?> fluent,LoadBalancer instance) {
    this(fluent, instance, false);
  }
  public LoadBalancerBuilder(LoadBalancerFluent<?> fluent,LoadBalancer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LoadBalancer());

    if (instance != null) {
      fluent.withPlatform(instance.getPlatform());
      fluent.withPlatform(instance.getPlatform());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LoadBalancerBuilder(LoadBalancer instance) {
    this(instance,false);
  }
  public LoadBalancerBuilder(LoadBalancer instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LoadBalancer());

    if (instance != null) {
      this.withPlatform(instance.getPlatform());
      this.withPlatform(instance.getPlatform());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LoadBalancerFluent<?> fluent;
  Boolean validationEnabled;
  public LoadBalancer build() {
    LoadBalancer buildable = new LoadBalancer(fluent.buildPlatform());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}