package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LDAPAttributeMappingBuilder extends LDAPAttributeMappingFluent<LDAPAttributeMappingBuilder> implements VisitableBuilder<LDAPAttributeMapping,LDAPAttributeMappingBuilder>{
  public LDAPAttributeMappingBuilder() {
    this(false);
  }
  public LDAPAttributeMappingBuilder(Boolean validationEnabled) {
    this(new LDAPAttributeMapping(), validationEnabled);
  }
  public LDAPAttributeMappingBuilder(LDAPAttributeMappingFluent<?> fluent) {
    this(fluent, false);
  }
  public LDAPAttributeMappingBuilder(LDAPAttributeMappingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LDAPAttributeMapping(), validationEnabled);
  }
  public LDAPAttributeMappingBuilder(LDAPAttributeMappingFluent<?> fluent,LDAPAttributeMapping instance) {
    this(fluent, instance, false);
  }
  public LDAPAttributeMappingBuilder(LDAPAttributeMappingFluent<?> fluent,LDAPAttributeMapping instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LDAPAttributeMapping());

    if (instance != null) {
      fluent.withEmail(instance.getEmail());
      fluent.withId(instance.getId());
      fluent.withName(instance.getName());
      fluent.withPreferredUsername(instance.getPreferredUsername());
      fluent.withEmail(instance.getEmail());
      fluent.withId(instance.getId());
      fluent.withName(instance.getName());
      fluent.withPreferredUsername(instance.getPreferredUsername());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LDAPAttributeMappingBuilder(LDAPAttributeMapping instance) {
    this(instance,false);
  }
  public LDAPAttributeMappingBuilder(LDAPAttributeMapping instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LDAPAttributeMapping());

    if (instance != null) {
      this.withEmail(instance.getEmail());
      this.withId(instance.getId());
      this.withName(instance.getName());
      this.withPreferredUsername(instance.getPreferredUsername());
      this.withEmail(instance.getEmail());
      this.withId(instance.getId());
      this.withName(instance.getName());
      this.withPreferredUsername(instance.getPreferredUsername());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LDAPAttributeMappingFluent<?> fluent;
  Boolean validationEnabled;
  public LDAPAttributeMapping build() {
    LDAPAttributeMapping buildable = new LDAPAttributeMapping(fluent.getEmail(),fluent.getId(),fluent.getName(),fluent.getPreferredUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}