package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KeystoneIdentityProviderFluent<A extends KeystoneIdentityProviderFluent<A>> extends BaseFluent<A>{
  public KeystoneIdentityProviderFluent() {
  }
  public KeystoneIdentityProviderFluent(KeystoneIdentityProvider instance) {
    instance = (instance != null ? instance : new KeystoneIdentityProvider());

    if (instance != null) {
      this.withCa(instance.getCa());
      this.withDomainName(instance.getDomainName());
      this.withTlsClientCert(instance.getTlsClientCert());
      this.withTlsClientKey(instance.getTlsClientKey());
      this.withUrl(instance.getUrl());
      this.withCa(instance.getCa());
      this.withDomainName(instance.getDomainName());
      this.withTlsClientCert(instance.getTlsClientCert());
      this.withTlsClientKey(instance.getTlsClientKey());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ConfigMapNameReferenceBuilder ca;
  private String domainName;
  private SecretNameReferenceBuilder tlsClientCert;
  private SecretNameReferenceBuilder tlsClientKey;
  private String url;
  private Map<String,Object> additionalProperties;
  public ConfigMapNameReference buildCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public A withCa(ConfigMapNameReference ca) {
    _visitables.get("ca").remove(this.ca);
    if (ca!=null){ this.ca= new ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} else { this.ca = null; _visitables.get("ca").remove(this.ca); } return (A) this;
  }
  public boolean hasCa() {
    return this.ca != null;
  }
  public A withNewCa(String name) {
    return (A)withCa(new ConfigMapNameReference(name));
  }
  public CaNested<A> withNewCa() {
    return new CaNested(null);
  }
  public CaNested<A> withNewCaLike(ConfigMapNameReference item) {
    return new CaNested(item);
  }
  public CaNested<A> editCa() {
    return withNewCaLike(java.util.Optional.ofNullable(buildCa()).orElse(null));
  }
  public CaNested<A> editOrNewCa() {
    return withNewCaLike(java.util.Optional.ofNullable(buildCa()).orElse(new ConfigMapNameReferenceBuilder().build()));
  }
  public CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
    return withNewCaLike(java.util.Optional.ofNullable(buildCa()).orElse(item));
  }
  public String getDomainName() {
    return this.domainName;
  }
  public A withDomainName(String domainName) {
    this.domainName=domainName; return (A) this;
  }
  public boolean hasDomainName() {
    return this.domainName != null;
  }
  public SecretNameReference buildTlsClientCert() {
    return this.tlsClientCert!=null ?this.tlsClientCert.build():null;
  }
  public A withTlsClientCert(SecretNameReference tlsClientCert) {
    _visitables.get("tlsClientCert").remove(this.tlsClientCert);
    if (tlsClientCert!=null){ this.tlsClientCert= new SecretNameReferenceBuilder(tlsClientCert); _visitables.get("tlsClientCert").add(this.tlsClientCert);} else { this.tlsClientCert = null; _visitables.get("tlsClientCert").remove(this.tlsClientCert); } return (A) this;
  }
  public boolean hasTlsClientCert() {
    return this.tlsClientCert != null;
  }
  public A withNewTlsClientCert(String name) {
    return (A)withTlsClientCert(new SecretNameReference(name));
  }
  public TlsClientCertNested<A> withNewTlsClientCert() {
    return new TlsClientCertNested(null);
  }
  public TlsClientCertNested<A> withNewTlsClientCertLike(SecretNameReference item) {
    return new TlsClientCertNested(item);
  }
  public TlsClientCertNested<A> editTlsClientCert() {
    return withNewTlsClientCertLike(java.util.Optional.ofNullable(buildTlsClientCert()).orElse(null));
  }
  public TlsClientCertNested<A> editOrNewTlsClientCert() {
    return withNewTlsClientCertLike(java.util.Optional.ofNullable(buildTlsClientCert()).orElse(new SecretNameReferenceBuilder().build()));
  }
  public TlsClientCertNested<A> editOrNewTlsClientCertLike(SecretNameReference item) {
    return withNewTlsClientCertLike(java.util.Optional.ofNullable(buildTlsClientCert()).orElse(item));
  }
  public SecretNameReference buildTlsClientKey() {
    return this.tlsClientKey!=null ?this.tlsClientKey.build():null;
  }
  public A withTlsClientKey(SecretNameReference tlsClientKey) {
    _visitables.get("tlsClientKey").remove(this.tlsClientKey);
    if (tlsClientKey!=null){ this.tlsClientKey= new SecretNameReferenceBuilder(tlsClientKey); _visitables.get("tlsClientKey").add(this.tlsClientKey);} else { this.tlsClientKey = null; _visitables.get("tlsClientKey").remove(this.tlsClientKey); } return (A) this;
  }
  public boolean hasTlsClientKey() {
    return this.tlsClientKey != null;
  }
  public A withNewTlsClientKey(String name) {
    return (A)withTlsClientKey(new SecretNameReference(name));
  }
  public TlsClientKeyNested<A> withNewTlsClientKey() {
    return new TlsClientKeyNested(null);
  }
  public TlsClientKeyNested<A> withNewTlsClientKeyLike(SecretNameReference item) {
    return new TlsClientKeyNested(item);
  }
  public TlsClientKeyNested<A> editTlsClientKey() {
    return withNewTlsClientKeyLike(java.util.Optional.ofNullable(buildTlsClientKey()).orElse(null));
  }
  public TlsClientKeyNested<A> editOrNewTlsClientKey() {
    return withNewTlsClientKeyLike(java.util.Optional.ofNullable(buildTlsClientKey()).orElse(new SecretNameReferenceBuilder().build()));
  }
  public TlsClientKeyNested<A> editOrNewTlsClientKeyLike(SecretNameReference item) {
    return withNewTlsClientKeyLike(java.util.Optional.ofNullable(buildTlsClientKey()).orElse(item));
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public boolean hasUrl() {
    return this.url != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KeystoneIdentityProviderFluent that = (KeystoneIdentityProviderFluent) o;
    if (!java.util.Objects.equals(ca, that.ca)) return false;

    if (!java.util.Objects.equals(domainName, that.domainName)) return false;

    if (!java.util.Objects.equals(tlsClientCert, that.tlsClientCert)) return false;

    if (!java.util.Objects.equals(tlsClientKey, that.tlsClientKey)) return false;

    if (!java.util.Objects.equals(url, that.url)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ca,  domainName,  tlsClientCert,  tlsClientKey,  url,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (domainName != null) { sb.append("domainName:"); sb.append(domainName + ","); }
    if (tlsClientCert != null) { sb.append("tlsClientCert:"); sb.append(tlsClientCert + ","); }
    if (tlsClientKey != null) { sb.append("tlsClientKey:"); sb.append(tlsClientKey + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CaNested<N> extends ConfigMapNameReferenceFluent<CaNested<N>> implements Nested<N>{
    CaNested(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    ConfigMapNameReferenceBuilder builder;
    public N and() {
      return (N) KeystoneIdentityProviderFluent.this.withCa(builder.build());
    }
    public N endCa() {
      return and();
    }
    
  }
  public class TlsClientCertNested<N> extends SecretNameReferenceFluent<TlsClientCertNested<N>> implements Nested<N>{
    TlsClientCertNested(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    SecretNameReferenceBuilder builder;
    public N and() {
      return (N) KeystoneIdentityProviderFluent.this.withTlsClientCert(builder.build());
    }
    public N endTlsClientCert() {
      return and();
    }
    
  }
  public class TlsClientKeyNested<N> extends SecretNameReferenceFluent<TlsClientKeyNested<N>> implements Nested<N>{
    TlsClientKeyNested(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    SecretNameReferenceBuilder builder;
    public N and() {
      return (N) KeystoneIdentityProviderFluent.this.withTlsClientKey(builder.build());
    }
    public N endTlsClientKey() {
      return and();
    }
    
  }
  
}