package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KeystoneIdentityProviderBuilder extends KeystoneIdentityProviderFluent<KeystoneIdentityProviderBuilder> implements VisitableBuilder<KeystoneIdentityProvider,KeystoneIdentityProviderBuilder>{
  public KeystoneIdentityProviderBuilder() {
    this(false);
  }
  public KeystoneIdentityProviderBuilder(Boolean validationEnabled) {
    this(new KeystoneIdentityProvider(), validationEnabled);
  }
  public KeystoneIdentityProviderBuilder(KeystoneIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public KeystoneIdentityProviderBuilder(KeystoneIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KeystoneIdentityProvider(), validationEnabled);
  }
  public KeystoneIdentityProviderBuilder(KeystoneIdentityProviderFluent<?> fluent,KeystoneIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public KeystoneIdentityProviderBuilder(KeystoneIdentityProviderFluent<?> fluent,KeystoneIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KeystoneIdentityProvider());

    if (instance != null) {
      fluent.withCa(instance.getCa());
      fluent.withDomainName(instance.getDomainName());
      fluent.withTlsClientCert(instance.getTlsClientCert());
      fluent.withTlsClientKey(instance.getTlsClientKey());
      fluent.withUrl(instance.getUrl());
      fluent.withCa(instance.getCa());
      fluent.withDomainName(instance.getDomainName());
      fluent.withTlsClientCert(instance.getTlsClientCert());
      fluent.withTlsClientKey(instance.getTlsClientKey());
      fluent.withUrl(instance.getUrl());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KeystoneIdentityProviderBuilder(KeystoneIdentityProvider instance) {
    this(instance,false);
  }
  public KeystoneIdentityProviderBuilder(KeystoneIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KeystoneIdentityProvider());

    if (instance != null) {
      this.withCa(instance.getCa());
      this.withDomainName(instance.getDomainName());
      this.withTlsClientCert(instance.getTlsClientCert());
      this.withTlsClientKey(instance.getTlsClientKey());
      this.withUrl(instance.getUrl());
      this.withCa(instance.getCa());
      this.withDomainName(instance.getDomainName());
      this.withTlsClientCert(instance.getTlsClientCert());
      this.withTlsClientKey(instance.getTlsClientKey());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KeystoneIdentityProviderFluent<?> fluent;
  Boolean validationEnabled;
  public KeystoneIdentityProvider build() {
    KeystoneIdentityProvider buildable = new KeystoneIdentityProvider(fluent.buildCa(),fluent.getDomainName(),fluent.buildTlsClientCert(),fluent.buildTlsClientKey(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}