package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressStatusFluent<A extends IngressStatusFluent<A>> extends BaseFluent<A>{
  public IngressStatusFluent() {
  }
  public IngressStatusFluent(IngressStatus instance) {
    instance = (instance != null ? instance : new IngressStatus());

    if (instance != null) {
      this.withComponentRoutes(instance.getComponentRoutes());
      this.withDefaultPlacement(instance.getDefaultPlacement());
      this.withComponentRoutes(instance.getComponentRoutes());
      this.withDefaultPlacement(instance.getDefaultPlacement());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ComponentRouteStatusBuilder> componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();
  private String defaultPlacement;
  private Map<String,Object> additionalProperties;
  public A addToComponentRoutes(int index,ComponentRouteStatus item) {
    if (this.componentRoutes == null) {this.componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();}
    ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
    if (index < 0 || index >= componentRoutes.size()) { _visitables.get("componentRoutes").add(builder); componentRoutes.add(builder); } else { _visitables.get("componentRoutes").add(index, builder); componentRoutes.add(index, builder);}
    return (A)this;
  }
  public A setToComponentRoutes(int index,ComponentRouteStatus item) {
    if (this.componentRoutes == null) {this.componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();}
    ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
    if (index < 0 || index >= componentRoutes.size()) { _visitables.get("componentRoutes").add(builder); componentRoutes.add(builder); } else { _visitables.get("componentRoutes").set(index, builder); componentRoutes.set(index, builder);}
    return (A)this;
  }
  public A addToComponentRoutes(io.fabric8.openshift.api.model.config.v1.ComponentRouteStatus... items) {
    if (this.componentRoutes == null) {this.componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();}
    for (ComponentRouteStatus item : items) {ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);_visitables.get("componentRoutes").add(builder);this.componentRoutes.add(builder);} return (A)this;
  }
  public A addAllToComponentRoutes(Collection<ComponentRouteStatus> items) {
    if (this.componentRoutes == null) {this.componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();}
    for (ComponentRouteStatus item : items) {ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);_visitables.get("componentRoutes").add(builder);this.componentRoutes.add(builder);} return (A)this;
  }
  public A removeFromComponentRoutes(io.fabric8.openshift.api.model.config.v1.ComponentRouteStatus... items) {
    if (this.componentRoutes == null) return (A)this;
    for (ComponentRouteStatus item : items) {ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);_visitables.get("componentRoutes").remove(builder); this.componentRoutes.remove(builder);} return (A)this;
  }
  public A removeAllFromComponentRoutes(Collection<ComponentRouteStatus> items) {
    if (this.componentRoutes == null) return (A)this;
    for (ComponentRouteStatus item : items) {ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);_visitables.get("componentRoutes").remove(builder); this.componentRoutes.remove(builder);} return (A)this;
  }
  public A removeMatchingFromComponentRoutes(Predicate<ComponentRouteStatusBuilder> predicate) {
    if (componentRoutes == null) return (A) this;
    final Iterator<ComponentRouteStatusBuilder> each = componentRoutes.iterator();
    final List visitables = _visitables.get("componentRoutes");
    while (each.hasNext()) {
      ComponentRouteStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ComponentRouteStatus> buildComponentRoutes() {
    return componentRoutes != null ? build(componentRoutes) : null;
  }
  public ComponentRouteStatus buildComponentRoute(int index) {
    return this.componentRoutes.get(index).build();
  }
  public ComponentRouteStatus buildFirstComponentRoute() {
    return this.componentRoutes.get(0).build();
  }
  public ComponentRouteStatus buildLastComponentRoute() {
    return this.componentRoutes.get(componentRoutes.size() - 1).build();
  }
  public ComponentRouteStatus buildMatchingComponentRoute(Predicate<ComponentRouteStatusBuilder> predicate) {
    for (ComponentRouteStatusBuilder item: componentRoutes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingComponentRoute(Predicate<ComponentRouteStatusBuilder> predicate) {
    for (ComponentRouteStatusBuilder item: componentRoutes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withComponentRoutes(List<ComponentRouteStatus> componentRoutes) {
    if (this.componentRoutes != null) { _visitables.get("componentRoutes").clear();}
    if (componentRoutes != null) {this.componentRoutes = new ArrayList(); for (ComponentRouteStatus item : componentRoutes){this.addToComponentRoutes(item);}} else { this.componentRoutes = null;} return (A) this;
  }
  public A withComponentRoutes(io.fabric8.openshift.api.model.config.v1.ComponentRouteStatus... componentRoutes) {
    if (this.componentRoutes != null) {this.componentRoutes.clear(); _visitables.remove("componentRoutes"); }
    if (componentRoutes != null) {for (ComponentRouteStatus item :componentRoutes){ this.addToComponentRoutes(item);}} return (A) this;
  }
  public boolean hasComponentRoutes() {
    return componentRoutes != null && !componentRoutes.isEmpty();
  }
  public ComponentRoutesNested<A> addNewComponentRoute() {
    return new ComponentRoutesNested(-1, null);
  }
  public ComponentRoutesNested<A> addNewComponentRouteLike(ComponentRouteStatus item) {
    return new ComponentRoutesNested(-1, item);
  }
  public ComponentRoutesNested<A> setNewComponentRouteLike(int index,ComponentRouteStatus item) {
    return new ComponentRoutesNested(index, item);
  }
  public ComponentRoutesNested<A> editComponentRoute(int index) {
    if (componentRoutes.size() <= index) throw new RuntimeException("Can't edit componentRoutes. Index exceeds size.");
    return setNewComponentRouteLike(index, buildComponentRoute(index));
  }
  public ComponentRoutesNested<A> editFirstComponentRoute() {
    if (componentRoutes.size() == 0) throw new RuntimeException("Can't edit first componentRoutes. The list is empty.");
    return setNewComponentRouteLike(0, buildComponentRoute(0));
  }
  public ComponentRoutesNested<A> editLastComponentRoute() {
    int index = componentRoutes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last componentRoutes. The list is empty.");
    return setNewComponentRouteLike(index, buildComponentRoute(index));
  }
  public ComponentRoutesNested<A> editMatchingComponentRoute(Predicate<ComponentRouteStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<componentRoutes.size();i++) { 
    if (predicate.test(componentRoutes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching componentRoutes. No match found.");
    return setNewComponentRouteLike(index, buildComponentRoute(index));
  }
  public String getDefaultPlacement() {
    return this.defaultPlacement;
  }
  public A withDefaultPlacement(String defaultPlacement) {
    this.defaultPlacement=defaultPlacement; return (A) this;
  }
  public boolean hasDefaultPlacement() {
    return this.defaultPlacement != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressStatusFluent that = (IngressStatusFluent) o;
    if (!java.util.Objects.equals(componentRoutes, that.componentRoutes)) return false;

    if (!java.util.Objects.equals(defaultPlacement, that.defaultPlacement)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(componentRoutes,  defaultPlacement,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (componentRoutes != null && !componentRoutes.isEmpty()) { sb.append("componentRoutes:"); sb.append(componentRoutes + ","); }
    if (defaultPlacement != null) { sb.append("defaultPlacement:"); sb.append(defaultPlacement + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ComponentRoutesNested<N> extends ComponentRouteStatusFluent<ComponentRoutesNested<N>> implements Nested<N>{
    ComponentRoutesNested(int index,ComponentRouteStatus item) {
      this.index = index;
      this.builder = new ComponentRouteStatusBuilder(this, item);
    }
    ComponentRouteStatusBuilder builder;
    int index;
    public N and() {
      return (N) IngressStatusFluent.this.setToComponentRoutes(index,builder.build());
    }
    public N endComponentRoute() {
      return and();
    }
    
  }
  
}