package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class InfrastructureStatusFluent<A extends InfrastructureStatusFluent<A>> extends BaseFluent<A>{
  public InfrastructureStatusFluent() {
  }
  public InfrastructureStatusFluent(InfrastructureStatus instance) {
    instance = (instance != null ? instance : new InfrastructureStatus());

    if (instance != null) {
      this.withApiServerInternalURI(instance.getApiServerInternalURI());
      this.withApiServerURL(instance.getApiServerURL());
      this.withControlPlaneTopology(instance.getControlPlaneTopology());
      this.withCpuPartitioning(instance.getCpuPartitioning());
      this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
      this.withInfrastructureName(instance.getInfrastructureName());
      this.withInfrastructureTopology(instance.getInfrastructureTopology());
      this.withPlatform(instance.getPlatform());
      this.withPlatformStatus(instance.getPlatformStatus());
      this.withApiServerInternalURI(instance.getApiServerInternalURI());
      this.withApiServerURL(instance.getApiServerURL());
      this.withControlPlaneTopology(instance.getControlPlaneTopology());
      this.withCpuPartitioning(instance.getCpuPartitioning());
      this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
      this.withInfrastructureName(instance.getInfrastructureName());
      this.withInfrastructureTopology(instance.getInfrastructureTopology());
      this.withPlatform(instance.getPlatform());
      this.withPlatformStatus(instance.getPlatformStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiServerInternalURI;
  private String apiServerURL;
  private String controlPlaneTopology;
  private String cpuPartitioning;
  private String etcdDiscoveryDomain;
  private String infrastructureName;
  private String infrastructureTopology;
  private String platform;
  private PlatformStatusBuilder platformStatus;
  private Map<String,Object> additionalProperties;
  public String getApiServerInternalURI() {
    return this.apiServerInternalURI;
  }
  public A withApiServerInternalURI(String apiServerInternalURI) {
    this.apiServerInternalURI=apiServerInternalURI; return (A) this;
  }
  public boolean hasApiServerInternalURI() {
    return this.apiServerInternalURI != null;
  }
  public String getApiServerURL() {
    return this.apiServerURL;
  }
  public A withApiServerURL(String apiServerURL) {
    this.apiServerURL=apiServerURL; return (A) this;
  }
  public boolean hasApiServerURL() {
    return this.apiServerURL != null;
  }
  public String getControlPlaneTopology() {
    return this.controlPlaneTopology;
  }
  public A withControlPlaneTopology(String controlPlaneTopology) {
    this.controlPlaneTopology=controlPlaneTopology; return (A) this;
  }
  public boolean hasControlPlaneTopology() {
    return this.controlPlaneTopology != null;
  }
  public String getCpuPartitioning() {
    return this.cpuPartitioning;
  }
  public A withCpuPartitioning(String cpuPartitioning) {
    this.cpuPartitioning=cpuPartitioning; return (A) this;
  }
  public boolean hasCpuPartitioning() {
    return this.cpuPartitioning != null;
  }
  public String getEtcdDiscoveryDomain() {
    return this.etcdDiscoveryDomain;
  }
  public A withEtcdDiscoveryDomain(String etcdDiscoveryDomain) {
    this.etcdDiscoveryDomain=etcdDiscoveryDomain; return (A) this;
  }
  public boolean hasEtcdDiscoveryDomain() {
    return this.etcdDiscoveryDomain != null;
  }
  public String getInfrastructureName() {
    return this.infrastructureName;
  }
  public A withInfrastructureName(String infrastructureName) {
    this.infrastructureName=infrastructureName; return (A) this;
  }
  public boolean hasInfrastructureName() {
    return this.infrastructureName != null;
  }
  public String getInfrastructureTopology() {
    return this.infrastructureTopology;
  }
  public A withInfrastructureTopology(String infrastructureTopology) {
    this.infrastructureTopology=infrastructureTopology; return (A) this;
  }
  public boolean hasInfrastructureTopology() {
    return this.infrastructureTopology != null;
  }
  public String getPlatform() {
    return this.platform;
  }
  public A withPlatform(String platform) {
    this.platform=platform; return (A) this;
  }
  public boolean hasPlatform() {
    return this.platform != null;
  }
  public PlatformStatus buildPlatformStatus() {
    return this.platformStatus!=null ?this.platformStatus.build():null;
  }
  public A withPlatformStatus(PlatformStatus platformStatus) {
    _visitables.get("platformStatus").remove(this.platformStatus);
    if (platformStatus!=null){ this.platformStatus= new PlatformStatusBuilder(platformStatus); _visitables.get("platformStatus").add(this.platformStatus);} else { this.platformStatus = null; _visitables.get("platformStatus").remove(this.platformStatus); } return (A) this;
  }
  public boolean hasPlatformStatus() {
    return this.platformStatus != null;
  }
  public PlatformStatusNested<A> withNewPlatformStatus() {
    return new PlatformStatusNested(null);
  }
  public PlatformStatusNested<A> withNewPlatformStatusLike(PlatformStatus item) {
    return new PlatformStatusNested(item);
  }
  public PlatformStatusNested<A> editPlatformStatus() {
    return withNewPlatformStatusLike(java.util.Optional.ofNullable(buildPlatformStatus()).orElse(null));
  }
  public PlatformStatusNested<A> editOrNewPlatformStatus() {
    return withNewPlatformStatusLike(java.util.Optional.ofNullable(buildPlatformStatus()).orElse(new PlatformStatusBuilder().build()));
  }
  public PlatformStatusNested<A> editOrNewPlatformStatusLike(PlatformStatus item) {
    return withNewPlatformStatusLike(java.util.Optional.ofNullable(buildPlatformStatus()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InfrastructureStatusFluent that = (InfrastructureStatusFluent) o;
    if (!java.util.Objects.equals(apiServerInternalURI, that.apiServerInternalURI)) return false;

    if (!java.util.Objects.equals(apiServerURL, that.apiServerURL)) return false;

    if (!java.util.Objects.equals(controlPlaneTopology, that.controlPlaneTopology)) return false;

    if (!java.util.Objects.equals(cpuPartitioning, that.cpuPartitioning)) return false;

    if (!java.util.Objects.equals(etcdDiscoveryDomain, that.etcdDiscoveryDomain)) return false;

    if (!java.util.Objects.equals(infrastructureName, that.infrastructureName)) return false;

    if (!java.util.Objects.equals(infrastructureTopology, that.infrastructureTopology)) return false;

    if (!java.util.Objects.equals(platform, that.platform)) return false;

    if (!java.util.Objects.equals(platformStatus, that.platformStatus)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiServerInternalURI,  apiServerURL,  controlPlaneTopology,  cpuPartitioning,  etcdDiscoveryDomain,  infrastructureName,  infrastructureTopology,  platform,  platformStatus,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiServerInternalURI != null) { sb.append("apiServerInternalURI:"); sb.append(apiServerInternalURI + ","); }
    if (apiServerURL != null) { sb.append("apiServerURL:"); sb.append(apiServerURL + ","); }
    if (controlPlaneTopology != null) { sb.append("controlPlaneTopology:"); sb.append(controlPlaneTopology + ","); }
    if (cpuPartitioning != null) { sb.append("cpuPartitioning:"); sb.append(cpuPartitioning + ","); }
    if (etcdDiscoveryDomain != null) { sb.append("etcdDiscoveryDomain:"); sb.append(etcdDiscoveryDomain + ","); }
    if (infrastructureName != null) { sb.append("infrastructureName:"); sb.append(infrastructureName + ","); }
    if (infrastructureTopology != null) { sb.append("infrastructureTopology:"); sb.append(infrastructureTopology + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (platformStatus != null) { sb.append("platformStatus:"); sb.append(platformStatus + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PlatformStatusNested<N> extends PlatformStatusFluent<PlatformStatusNested<N>> implements Nested<N>{
    PlatformStatusNested(PlatformStatus item) {
      this.builder = new PlatformStatusBuilder(this, item);
    }
    PlatformStatusBuilder builder;
    public N and() {
      return (N) InfrastructureStatusFluent.this.withPlatformStatus(builder.build());
    }
    public N endPlatformStatus() {
      return and();
    }
    
  }
  
}