package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InfrastructureListBuilder extends InfrastructureListFluent<InfrastructureListBuilder> implements VisitableBuilder<InfrastructureList,InfrastructureListBuilder>{
  public InfrastructureListBuilder() {
    this(false);
  }
  public InfrastructureListBuilder(Boolean validationEnabled) {
    this(new InfrastructureList(), validationEnabled);
  }
  public InfrastructureListBuilder(InfrastructureListFluent<?> fluent) {
    this(fluent, false);
  }
  public InfrastructureListBuilder(InfrastructureListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InfrastructureList(), validationEnabled);
  }
  public InfrastructureListBuilder(InfrastructureListFluent<?> fluent,InfrastructureList instance) {
    this(fluent, instance, false);
  }
  public InfrastructureListBuilder(InfrastructureListFluent<?> fluent,InfrastructureList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new InfrastructureList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InfrastructureListBuilder(InfrastructureList instance) {
    this(instance,false);
  }
  public InfrastructureListBuilder(InfrastructureList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new InfrastructureList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  InfrastructureListFluent<?> fluent;
  Boolean validationEnabled;
  public InfrastructureList build() {
    InfrastructureList buildable = new InfrastructureList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}