package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageSpecBuilder extends ImageSpecFluent<ImageSpecBuilder> implements VisitableBuilder<ImageSpec,ImageSpecBuilder>{
  public ImageSpecBuilder() {
    this(false);
  }
  public ImageSpecBuilder(Boolean validationEnabled) {
    this(new ImageSpec(), validationEnabled);
  }
  public ImageSpecBuilder(ImageSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageSpecBuilder(ImageSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageSpec(), validationEnabled);
  }
  public ImageSpecBuilder(ImageSpecFluent<?> fluent,ImageSpec instance) {
    this(fluent, instance, false);
  }
  public ImageSpecBuilder(ImageSpecFluent<?> fluent,ImageSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageSpec());

    if (instance != null) {
      fluent.withAdditionalTrustedCA(instance.getAdditionalTrustedCA());
      fluent.withAllowedRegistriesForImport(instance.getAllowedRegistriesForImport());
      fluent.withExternalRegistryHostnames(instance.getExternalRegistryHostnames());
      fluent.withRegistrySources(instance.getRegistrySources());
      fluent.withAdditionalTrustedCA(instance.getAdditionalTrustedCA());
      fluent.withAllowedRegistriesForImport(instance.getAllowedRegistriesForImport());
      fluent.withExternalRegistryHostnames(instance.getExternalRegistryHostnames());
      fluent.withRegistrySources(instance.getRegistrySources());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageSpecBuilder(ImageSpec instance) {
    this(instance,false);
  }
  public ImageSpecBuilder(ImageSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageSpec());

    if (instance != null) {
      this.withAdditionalTrustedCA(instance.getAdditionalTrustedCA());
      this.withAllowedRegistriesForImport(instance.getAllowedRegistriesForImport());
      this.withExternalRegistryHostnames(instance.getExternalRegistryHostnames());
      this.withRegistrySources(instance.getRegistrySources());
      this.withAdditionalTrustedCA(instance.getAdditionalTrustedCA());
      this.withAllowedRegistriesForImport(instance.getAllowedRegistriesForImport());
      this.withExternalRegistryHostnames(instance.getExternalRegistryHostnames());
      this.withRegistrySources(instance.getRegistrySources());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ImageSpec build() {
    ImageSpec buildable = new ImageSpec(fluent.buildAdditionalTrustedCA(),fluent.buildAllowedRegistriesForImport(),fluent.getExternalRegistryHostnames(),fluent.buildRegistrySources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}