package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeatureGateDetailsBuilder extends FeatureGateDetailsFluent<FeatureGateDetailsBuilder> implements VisitableBuilder<FeatureGateDetails,FeatureGateDetailsBuilder>{
  public FeatureGateDetailsBuilder() {
    this(false);
  }
  public FeatureGateDetailsBuilder(Boolean validationEnabled) {
    this(new FeatureGateDetails(), validationEnabled);
  }
  public FeatureGateDetailsBuilder(FeatureGateDetailsFluent<?> fluent) {
    this(fluent, false);
  }
  public FeatureGateDetailsBuilder(FeatureGateDetailsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FeatureGateDetails(), validationEnabled);
  }
  public FeatureGateDetailsBuilder(FeatureGateDetailsFluent<?> fluent,FeatureGateDetails instance) {
    this(fluent, instance, false);
  }
  public FeatureGateDetailsBuilder(FeatureGateDetailsFluent<?> fluent,FeatureGateDetails instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FeatureGateDetails());

    if (instance != null) {
      fluent.withDisabled(instance.getDisabled());
      fluent.withEnabled(instance.getEnabled());
      fluent.withVersion(instance.getVersion());
      fluent.withDisabled(instance.getDisabled());
      fluent.withEnabled(instance.getEnabled());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FeatureGateDetailsBuilder(FeatureGateDetails instance) {
    this(instance,false);
  }
  public FeatureGateDetailsBuilder(FeatureGateDetails instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FeatureGateDetails());

    if (instance != null) {
      this.withDisabled(instance.getDisabled());
      this.withEnabled(instance.getEnabled());
      this.withVersion(instance.getVersion());
      this.withDisabled(instance.getDisabled());
      this.withEnabled(instance.getEnabled());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FeatureGateDetailsFluent<?> fluent;
  Boolean validationEnabled;
  public FeatureGateDetails build() {
    FeatureGateDetails buildable = new FeatureGateDetails(fluent.buildDisabled(),fluent.buildEnabled(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}