package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSZoneBuilder extends DNSZoneFluent<DNSZoneBuilder> implements VisitableBuilder<DNSZone,DNSZoneBuilder>{
  public DNSZoneBuilder() {
    this(false);
  }
  public DNSZoneBuilder(Boolean validationEnabled) {
    this(new DNSZone(), validationEnabled);
  }
  public DNSZoneBuilder(DNSZoneFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSZoneBuilder(DNSZoneFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSZone(), validationEnabled);
  }
  public DNSZoneBuilder(DNSZoneFluent<?> fluent,DNSZone instance) {
    this(fluent, instance, false);
  }
  public DNSZoneBuilder(DNSZoneFluent<?> fluent,DNSZone instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DNSZone());

    if (instance != null) {
      fluent.withId(instance.getId());
      fluent.withTags(instance.getTags());
      fluent.withId(instance.getId());
      fluent.withTags(instance.getTags());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSZoneBuilder(DNSZone instance) {
    this(instance,false);
  }
  public DNSZoneBuilder(DNSZone instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DNSZone());

    if (instance != null) {
      this.withId(instance.getId());
      this.withTags(instance.getTags());
      this.withId(instance.getId());
      this.withTags(instance.getTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSZoneFluent<?> fluent;
  Boolean validationEnabled;
  public DNSZone build() {
    DNSZone buildable = new DNSZone(fluent.getId(),fluent.getTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}