package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthenticationStatusBuilder extends AuthenticationStatusFluent<AuthenticationStatusBuilder> implements VisitableBuilder<AuthenticationStatus,AuthenticationStatusBuilder>{
  public AuthenticationStatusBuilder() {
    this(false);
  }
  public AuthenticationStatusBuilder(Boolean validationEnabled) {
    this(new AuthenticationStatus(), validationEnabled);
  }
  public AuthenticationStatusBuilder(AuthenticationStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthenticationStatusBuilder(AuthenticationStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AuthenticationStatus(), validationEnabled);
  }
  public AuthenticationStatusBuilder(AuthenticationStatusFluent<?> fluent,AuthenticationStatus instance) {
    this(fluent, instance, false);
  }
  public AuthenticationStatusBuilder(AuthenticationStatusFluent<?> fluent,AuthenticationStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AuthenticationStatus());

    if (instance != null) {
      fluent.withIntegratedOAuthMetadata(instance.getIntegratedOAuthMetadata());
      fluent.withIntegratedOAuthMetadata(instance.getIntegratedOAuthMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AuthenticationStatusBuilder(AuthenticationStatus instance) {
    this(instance,false);
  }
  public AuthenticationStatusBuilder(AuthenticationStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AuthenticationStatus());

    if (instance != null) {
      this.withIntegratedOAuthMetadata(instance.getIntegratedOAuthMetadata());
      this.withIntegratedOAuthMetadata(instance.getIntegratedOAuthMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AuthenticationStatusFluent<?> fluent;
  Boolean validationEnabled;
  public AuthenticationStatus build() {
    AuthenticationStatus buildable = new AuthenticationStatus(fluent.buildIntegratedOAuthMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}