package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VSpherePlatformStatusBuilder extends VSpherePlatformStatusFluent<VSpherePlatformStatusBuilder> implements VisitableBuilder<VSpherePlatformStatus,VSpherePlatformStatusBuilder>{
  public VSpherePlatformStatusBuilder() {
    this(false);
  }
  public VSpherePlatformStatusBuilder(Boolean validationEnabled) {
    this(new VSpherePlatformStatus(), validationEnabled);
  }
  public VSpherePlatformStatusBuilder(VSpherePlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public VSpherePlatformStatusBuilder(VSpherePlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VSpherePlatformStatus(), validationEnabled);
  }
  public VSpherePlatformStatusBuilder(VSpherePlatformStatusFluent<?> fluent,VSpherePlatformStatus instance) {
    this(fluent, instance, false);
  }
  public VSpherePlatformStatusBuilder(VSpherePlatformStatusFluent<?> fluent,VSpherePlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VSpherePlatformStatus());

    if (instance != null) {
      fluent.withApiServerInternalIP(instance.getApiServerInternalIP());
      fluent.withApiServerInternalIPs(instance.getApiServerInternalIPs());
      fluent.withIngressIP(instance.getIngressIP());
      fluent.withIngressIPs(instance.getIngressIPs());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withNodeDNSIP(instance.getNodeDNSIP());
      fluent.withApiServerInternalIP(instance.getApiServerInternalIP());
      fluent.withApiServerInternalIPs(instance.getApiServerInternalIPs());
      fluent.withIngressIP(instance.getIngressIP());
      fluent.withIngressIPs(instance.getIngressIPs());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withNodeDNSIP(instance.getNodeDNSIP());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VSpherePlatformStatusBuilder(VSpherePlatformStatus instance) {
    this(instance,false);
  }
  public VSpherePlatformStatusBuilder(VSpherePlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VSpherePlatformStatus());

    if (instance != null) {
      this.withApiServerInternalIP(instance.getApiServerInternalIP());
      this.withApiServerInternalIPs(instance.getApiServerInternalIPs());
      this.withIngressIP(instance.getIngressIP());
      this.withIngressIPs(instance.getIngressIPs());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withNodeDNSIP(instance.getNodeDNSIP());
      this.withApiServerInternalIP(instance.getApiServerInternalIP());
      this.withApiServerInternalIPs(instance.getApiServerInternalIPs());
      this.withIngressIP(instance.getIngressIP());
      this.withIngressIPs(instance.getIngressIPs());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withNodeDNSIP(instance.getNodeDNSIP());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VSpherePlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public VSpherePlatformStatus build() {
    VSpherePlatformStatus buildable = new VSpherePlatformStatus(fluent.getApiServerInternalIP(),fluent.getApiServerInternalIPs(),fluent.getIngressIP(),fluent.getIngressIPs(),fluent.buildLoadBalancer(),fluent.getNodeDNSIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}