package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VSpherePlatformSpecBuilder extends VSpherePlatformSpecFluent<VSpherePlatformSpecBuilder> implements VisitableBuilder<VSpherePlatformSpec,VSpherePlatformSpecBuilder>{
  public VSpherePlatformSpecBuilder() {
    this(false);
  }
  public VSpherePlatformSpecBuilder(Boolean validationEnabled) {
    this(new VSpherePlatformSpec(), validationEnabled);
  }
  public VSpherePlatformSpecBuilder(VSpherePlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public VSpherePlatformSpecBuilder(VSpherePlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VSpherePlatformSpec(), validationEnabled);
  }
  public VSpherePlatformSpecBuilder(VSpherePlatformSpecFluent<?> fluent,VSpherePlatformSpec instance) {
    this(fluent, instance, false);
  }
  public VSpherePlatformSpecBuilder(VSpherePlatformSpecFluent<?> fluent,VSpherePlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VSpherePlatformSpec());

    if (instance != null) {
      fluent.withFailureDomains(instance.getFailureDomains());
      fluent.withNodeNetworking(instance.getNodeNetworking());
      fluent.withVcenters(instance.getVcenters());
      fluent.withFailureDomains(instance.getFailureDomains());
      fluent.withNodeNetworking(instance.getNodeNetworking());
      fluent.withVcenters(instance.getVcenters());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VSpherePlatformSpecBuilder(VSpherePlatformSpec instance) {
    this(instance,false);
  }
  public VSpherePlatformSpecBuilder(VSpherePlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VSpherePlatformSpec());

    if (instance != null) {
      this.withFailureDomains(instance.getFailureDomains());
      this.withNodeNetworking(instance.getNodeNetworking());
      this.withVcenters(instance.getVcenters());
      this.withFailureDomains(instance.getFailureDomains());
      this.withNodeNetworking(instance.getNodeNetworking());
      this.withVcenters(instance.getVcenters());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VSpherePlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public VSpherePlatformSpec build() {
    VSpherePlatformSpec buildable = new VSpherePlatformSpec(fluent.buildFailureDomains(),fluent.buildNodeNetworking(),fluent.buildVcenters());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}