package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProxyStatusBuilder extends ProxyStatusFluent<ProxyStatusBuilder> implements VisitableBuilder<ProxyStatus,ProxyStatusBuilder>{
  public ProxyStatusBuilder() {
    this(false);
  }
  public ProxyStatusBuilder(Boolean validationEnabled) {
    this(new ProxyStatus(), validationEnabled);
  }
  public ProxyStatusBuilder(ProxyStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxyStatusBuilder(ProxyStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProxyStatus(), validationEnabled);
  }
  public ProxyStatusBuilder(ProxyStatusFluent<?> fluent,ProxyStatus instance) {
    this(fluent, instance, false);
  }
  public ProxyStatusBuilder(ProxyStatusFluent<?> fluent,ProxyStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProxyStatus());

    if (instance != null) {
      fluent.withHttpProxy(instance.getHttpProxy());
      fluent.withHttpsProxy(instance.getHttpsProxy());
      fluent.withNoProxy(instance.getNoProxy());
      fluent.withHttpProxy(instance.getHttpProxy());
      fluent.withHttpsProxy(instance.getHttpsProxy());
      fluent.withNoProxy(instance.getNoProxy());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProxyStatusBuilder(ProxyStatus instance) {
    this(instance,false);
  }
  public ProxyStatusBuilder(ProxyStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProxyStatus());

    if (instance != null) {
      this.withHttpProxy(instance.getHttpProxy());
      this.withHttpsProxy(instance.getHttpsProxy());
      this.withNoProxy(instance.getNoProxy());
      this.withHttpProxy(instance.getHttpProxy());
      this.withHttpsProxy(instance.getHttpsProxy());
      this.withNoProxy(instance.getNoProxy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProxyStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ProxyStatus build() {
    ProxyStatus buildable = new ProxyStatus(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}