package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorHubSpecBuilder extends OperatorHubSpecFluent<OperatorHubSpecBuilder> implements VisitableBuilder<OperatorHubSpec,OperatorHubSpecBuilder>{
  public OperatorHubSpecBuilder() {
    this(false);
  }
  public OperatorHubSpecBuilder(Boolean validationEnabled) {
    this(new OperatorHubSpec(), validationEnabled);
  }
  public OperatorHubSpecBuilder(OperatorHubSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorHubSpecBuilder(OperatorHubSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorHubSpec(), validationEnabled);
  }
  public OperatorHubSpecBuilder(OperatorHubSpecFluent<?> fluent,OperatorHubSpec instance) {
    this(fluent, instance, false);
  }
  public OperatorHubSpecBuilder(OperatorHubSpecFluent<?> fluent,OperatorHubSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OperatorHubSpec());

    if (instance != null) {
      fluent.withDisableAllDefaultSources(instance.getDisableAllDefaultSources());
      fluent.withSources(instance.getSources());
      fluent.withDisableAllDefaultSources(instance.getDisableAllDefaultSources());
      fluent.withSources(instance.getSources());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperatorHubSpecBuilder(OperatorHubSpec instance) {
    this(instance,false);
  }
  public OperatorHubSpecBuilder(OperatorHubSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OperatorHubSpec());

    if (instance != null) {
      this.withDisableAllDefaultSources(instance.getDisableAllDefaultSources());
      this.withSources(instance.getSources());
      this.withDisableAllDefaultSources(instance.getDisableAllDefaultSources());
      this.withSources(instance.getSources());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperatorHubSpecFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorHubSpec build() {
    OperatorHubSpec buildable = new OperatorHubSpec(fluent.getDisableAllDefaultSources(),fluent.buildSources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}