package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressSpecBuilder extends IngressSpecFluent<IngressSpecBuilder> implements VisitableBuilder<IngressSpec,IngressSpecBuilder>{
  public IngressSpecBuilder() {
    this(false);
  }
  public IngressSpecBuilder(Boolean validationEnabled) {
    this(new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent,IngressSpec instance) {
    this(fluent, instance, false);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent,IngressSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IngressSpec());

    if (instance != null) {
      fluent.withAppsDomain(instance.getAppsDomain());
      fluent.withComponentRoutes(instance.getComponentRoutes());
      fluent.withDomain(instance.getDomain());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withRequiredHSTSPolicies(instance.getRequiredHSTSPolicies());
      fluent.withAppsDomain(instance.getAppsDomain());
      fluent.withComponentRoutes(instance.getComponentRoutes());
      fluent.withDomain(instance.getDomain());
      fluent.withLoadBalancer(instance.getLoadBalancer());
      fluent.withRequiredHSTSPolicies(instance.getRequiredHSTSPolicies());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressSpecBuilder(IngressSpec instance) {
    this(instance,false);
  }
  public IngressSpecBuilder(IngressSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IngressSpec());

    if (instance != null) {
      this.withAppsDomain(instance.getAppsDomain());
      this.withComponentRoutes(instance.getComponentRoutes());
      this.withDomain(instance.getDomain());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withRequiredHSTSPolicies(instance.getRequiredHSTSPolicies());
      this.withAppsDomain(instance.getAppsDomain());
      this.withComponentRoutes(instance.getComponentRoutes());
      this.withDomain(instance.getDomain());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withRequiredHSTSPolicies(instance.getRequiredHSTSPolicies());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IngressSpec build() {
    IngressSpec buildable = new IngressSpec(fluent.getAppsDomain(),fluent.buildComponentRoutes(),fluent.getDomain(),fluent.buildLoadBalancer(),fluent.buildRequiredHSTSPolicies());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}