package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageBuilder extends ImageFluent<ImageBuilder> implements VisitableBuilder<Image,ImageBuilder>{
  public ImageBuilder() {
    this(false);
  }
  public ImageBuilder(Boolean validationEnabled) {
    this(new Image(), validationEnabled);
  }
  public ImageBuilder(ImageFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageBuilder(ImageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Image(), validationEnabled);
  }
  public ImageBuilder(ImageFluent<?> fluent,Image instance) {
    this(fluent, instance, false);
  }
  public ImageBuilder(ImageFluent<?> fluent,Image instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Image());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageBuilder(Image instance) {
    this(instance,false);
  }
  public ImageBuilder(Image instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Image());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageFluent<?> fluent;
  Boolean validationEnabled;
  public Image build() {
    Image buildable = new Image(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}