package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IdentityProviderBuilder extends IdentityProviderFluent<IdentityProviderBuilder> implements VisitableBuilder<IdentityProvider,IdentityProviderBuilder>{
  public IdentityProviderBuilder() {
    this(false);
  }
  public IdentityProviderBuilder(Boolean validationEnabled) {
    this(new IdentityProvider(), validationEnabled);
  }
  public IdentityProviderBuilder(IdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public IdentityProviderBuilder(IdentityProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IdentityProvider(), validationEnabled);
  }
  public IdentityProviderBuilder(IdentityProviderFluent<?> fluent,IdentityProvider instance) {
    this(fluent, instance, false);
  }
  public IdentityProviderBuilder(IdentityProviderFluent<?> fluent,IdentityProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IdentityProvider());

    if (instance != null) {
      fluent.withBasicAuth(instance.getBasicAuth());
      fluent.withGithub(instance.getGithub());
      fluent.withGitlab(instance.getGitlab());
      fluent.withGoogle(instance.getGoogle());
      fluent.withHtpasswd(instance.getHtpasswd());
      fluent.withKeystone(instance.getKeystone());
      fluent.withLdap(instance.getLdap());
      fluent.withMappingMethod(instance.getMappingMethod());
      fluent.withName(instance.getName());
      fluent.withOpenID(instance.getOpenID());
      fluent.withRequestHeader(instance.getRequestHeader());
      fluent.withType(instance.getType());
      fluent.withBasicAuth(instance.getBasicAuth());
      fluent.withGithub(instance.getGithub());
      fluent.withGitlab(instance.getGitlab());
      fluent.withGoogle(instance.getGoogle());
      fluent.withHtpasswd(instance.getHtpasswd());
      fluent.withKeystone(instance.getKeystone());
      fluent.withLdap(instance.getLdap());
      fluent.withMappingMethod(instance.getMappingMethod());
      fluent.withName(instance.getName());
      fluent.withOpenID(instance.getOpenID());
      fluent.withRequestHeader(instance.getRequestHeader());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IdentityProviderBuilder(IdentityProvider instance) {
    this(instance,false);
  }
  public IdentityProviderBuilder(IdentityProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IdentityProvider());

    if (instance != null) {
      this.withBasicAuth(instance.getBasicAuth());
      this.withGithub(instance.getGithub());
      this.withGitlab(instance.getGitlab());
      this.withGoogle(instance.getGoogle());
      this.withHtpasswd(instance.getHtpasswd());
      this.withKeystone(instance.getKeystone());
      this.withLdap(instance.getLdap());
      this.withMappingMethod(instance.getMappingMethod());
      this.withName(instance.getName());
      this.withOpenID(instance.getOpenID());
      this.withRequestHeader(instance.getRequestHeader());
      this.withType(instance.getType());
      this.withBasicAuth(instance.getBasicAuth());
      this.withGithub(instance.getGithub());
      this.withGitlab(instance.getGitlab());
      this.withGoogle(instance.getGoogle());
      this.withHtpasswd(instance.getHtpasswd());
      this.withKeystone(instance.getKeystone());
      this.withLdap(instance.getLdap());
      this.withMappingMethod(instance.getMappingMethod());
      this.withName(instance.getName());
      this.withOpenID(instance.getOpenID());
      this.withRequestHeader(instance.getRequestHeader());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IdentityProviderFluent<?> fluent;
  Boolean validationEnabled;
  public IdentityProvider build() {
    IdentityProvider buildable = new IdentityProvider(fluent.buildBasicAuth(),fluent.buildGithub(),fluent.buildGitlab(),fluent.buildGoogle(),fluent.buildHtpasswd(),fluent.buildKeystone(),fluent.buildLdap(),fluent.getMappingMethod(),fluent.getName(),fluent.buildOpenID(),fluent.buildRequestHeader(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}