package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GCPPlatformSpecBuilder extends GCPPlatformSpecFluent<GCPPlatformSpecBuilder> implements VisitableBuilder<GCPPlatformSpec,GCPPlatformSpecBuilder>{
  public GCPPlatformSpecBuilder() {
    this(false);
  }
  public GCPPlatformSpecBuilder(Boolean validationEnabled) {
    this(new GCPPlatformSpec(), validationEnabled);
  }
  public GCPPlatformSpecBuilder(GCPPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public GCPPlatformSpecBuilder(GCPPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GCPPlatformSpec(), validationEnabled);
  }
  public GCPPlatformSpecBuilder(GCPPlatformSpecFluent<?> fluent,GCPPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public GCPPlatformSpecBuilder(GCPPlatformSpecFluent<?> fluent,GCPPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GCPPlatformSpec());

    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GCPPlatformSpecBuilder(GCPPlatformSpec instance) {
    this(instance,false);
  }
  public GCPPlatformSpecBuilder(GCPPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GCPPlatformSpec());

    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GCPPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public GCPPlatformSpec build() {
    GCPPlatformSpec buildable = new GCPPlatformSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}