package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalPlatformStatusBuilder extends ExternalPlatformStatusFluent<ExternalPlatformStatusBuilder> implements VisitableBuilder<ExternalPlatformStatus,ExternalPlatformStatusBuilder>{
  public ExternalPlatformStatusBuilder() {
    this(false);
  }
  public ExternalPlatformStatusBuilder(Boolean validationEnabled) {
    this(new ExternalPlatformStatus(), validationEnabled);
  }
  public ExternalPlatformStatusBuilder(ExternalPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalPlatformStatusBuilder(ExternalPlatformStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalPlatformStatus(), validationEnabled);
  }
  public ExternalPlatformStatusBuilder(ExternalPlatformStatusFluent<?> fluent,ExternalPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public ExternalPlatformStatusBuilder(ExternalPlatformStatusFluent<?> fluent,ExternalPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExternalPlatformStatus());

    if (instance != null) {
      fluent.withCloudControllerManager(instance.getCloudControllerManager());
      fluent.withCloudControllerManager(instance.getCloudControllerManager());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalPlatformStatusBuilder(ExternalPlatformStatus instance) {
    this(instance,false);
  }
  public ExternalPlatformStatusBuilder(ExternalPlatformStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExternalPlatformStatus());

    if (instance != null) {
      this.withCloudControllerManager(instance.getCloudControllerManager());
      this.withCloudControllerManager(instance.getCloudControllerManager());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalPlatformStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalPlatformStatus build() {
    ExternalPlatformStatus buildable = new ExternalPlatformStatus(fluent.buildCloudControllerManager());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}