package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalPlatformSpecBuilder extends ExternalPlatformSpecFluent<ExternalPlatformSpecBuilder> implements VisitableBuilder<ExternalPlatformSpec,ExternalPlatformSpecBuilder>{
  public ExternalPlatformSpecBuilder() {
    this(false);
  }
  public ExternalPlatformSpecBuilder(Boolean validationEnabled) {
    this(new ExternalPlatformSpec(), validationEnabled);
  }
  public ExternalPlatformSpecBuilder(ExternalPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalPlatformSpecBuilder(ExternalPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalPlatformSpec(), validationEnabled);
  }
  public ExternalPlatformSpecBuilder(ExternalPlatformSpecFluent<?> fluent,ExternalPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public ExternalPlatformSpecBuilder(ExternalPlatformSpecFluent<?> fluent,ExternalPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExternalPlatformSpec());

    if (instance != null) {
      fluent.withPlatformName(instance.getPlatformName());
      fluent.withPlatformName(instance.getPlatformName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalPlatformSpecBuilder(ExternalPlatformSpec instance) {
    this(instance,false);
  }
  public ExternalPlatformSpecBuilder(ExternalPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExternalPlatformSpec());

    if (instance != null) {
      this.withPlatformName(instance.getPlatformName());
      this.withPlatformName(instance.getPlatformName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalPlatformSpec build() {
    ExternalPlatformSpec buildable = new ExternalPlatformSpec(fluent.getPlatformName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}