package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConditionalUpdateRiskFluent<A extends ConditionalUpdateRiskFluent<A>> extends BaseFluent<A>{
  public ConditionalUpdateRiskFluent() {
  }
  public ConditionalUpdateRiskFluent(ConditionalUpdateRisk instance) {
    instance = (instance != null ? instance : new ConditionalUpdateRisk());

    if (instance != null) {
      this.withMatchingRules(instance.getMatchingRules());
      this.withMessage(instance.getMessage());
      this.withName(instance.getName());
      this.withUrl(instance.getUrl());
      this.withMatchingRules(instance.getMatchingRules());
      this.withMessage(instance.getMessage());
      this.withName(instance.getName());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ClusterConditionBuilder> matchingRules = new ArrayList<ClusterConditionBuilder>();
  private String message;
  private String name;
  private String url;
  private Map<String,Object> additionalProperties;
  public A addToMatchingRules(int index,ClusterCondition item) {
    if (this.matchingRules == null) {this.matchingRules = new ArrayList<ClusterConditionBuilder>();}
    ClusterConditionBuilder builder = new ClusterConditionBuilder(item);
    if (index < 0 || index >= matchingRules.size()) { _visitables.get("matchingRules").add(builder); matchingRules.add(builder); } else { _visitables.get("matchingRules").add(index, builder); matchingRules.add(index, builder);}
    return (A)this;
  }
  public A setToMatchingRules(int index,ClusterCondition item) {
    if (this.matchingRules == null) {this.matchingRules = new ArrayList<ClusterConditionBuilder>();}
    ClusterConditionBuilder builder = new ClusterConditionBuilder(item);
    if (index < 0 || index >= matchingRules.size()) { _visitables.get("matchingRules").add(builder); matchingRules.add(builder); } else { _visitables.get("matchingRules").set(index, builder); matchingRules.set(index, builder);}
    return (A)this;
  }
  public A addToMatchingRules(io.fabric8.openshift.api.model.config.v1.ClusterCondition... items) {
    if (this.matchingRules == null) {this.matchingRules = new ArrayList<ClusterConditionBuilder>();}
    for (ClusterCondition item : items) {ClusterConditionBuilder builder = new ClusterConditionBuilder(item);_visitables.get("matchingRules").add(builder);this.matchingRules.add(builder);} return (A)this;
  }
  public A addAllToMatchingRules(Collection<ClusterCondition> items) {
    if (this.matchingRules == null) {this.matchingRules = new ArrayList<ClusterConditionBuilder>();}
    for (ClusterCondition item : items) {ClusterConditionBuilder builder = new ClusterConditionBuilder(item);_visitables.get("matchingRules").add(builder);this.matchingRules.add(builder);} return (A)this;
  }
  public A removeFromMatchingRules(io.fabric8.openshift.api.model.config.v1.ClusterCondition... items) {
    if (this.matchingRules == null) return (A)this;
    for (ClusterCondition item : items) {ClusterConditionBuilder builder = new ClusterConditionBuilder(item);_visitables.get("matchingRules").remove(builder); this.matchingRules.remove(builder);} return (A)this;
  }
  public A removeAllFromMatchingRules(Collection<ClusterCondition> items) {
    if (this.matchingRules == null) return (A)this;
    for (ClusterCondition item : items) {ClusterConditionBuilder builder = new ClusterConditionBuilder(item);_visitables.get("matchingRules").remove(builder); this.matchingRules.remove(builder);} return (A)this;
  }
  public A removeMatchingFromMatchingRules(Predicate<ClusterConditionBuilder> predicate) {
    if (matchingRules == null) return (A) this;
    final Iterator<ClusterConditionBuilder> each = matchingRules.iterator();
    final List visitables = _visitables.get("matchingRules");
    while (each.hasNext()) {
      ClusterConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ClusterCondition> buildMatchingRules() {
    return matchingRules != null ? build(matchingRules) : null;
  }
  public ClusterCondition buildMatchingRule(int index) {
    return this.matchingRules.get(index).build();
  }
  public ClusterCondition buildFirstMatchingRule() {
    return this.matchingRules.get(0).build();
  }
  public ClusterCondition buildLastMatchingRule() {
    return this.matchingRules.get(matchingRules.size() - 1).build();
  }
  public ClusterCondition buildMatchingMatchingRule(Predicate<ClusterConditionBuilder> predicate) {
    for (ClusterConditionBuilder item: matchingRules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingMatchingRule(Predicate<ClusterConditionBuilder> predicate) {
    for (ClusterConditionBuilder item: matchingRules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatchingRules(List<ClusterCondition> matchingRules) {
    if (this.matchingRules != null) { _visitables.get("matchingRules").clear();}
    if (matchingRules != null) {this.matchingRules = new ArrayList(); for (ClusterCondition item : matchingRules){this.addToMatchingRules(item);}} else { this.matchingRules = null;} return (A) this;
  }
  public A withMatchingRules(io.fabric8.openshift.api.model.config.v1.ClusterCondition... matchingRules) {
    if (this.matchingRules != null) {this.matchingRules.clear(); _visitables.remove("matchingRules"); }
    if (matchingRules != null) {for (ClusterCondition item :matchingRules){ this.addToMatchingRules(item);}} return (A) this;
  }
  public boolean hasMatchingRules() {
    return matchingRules != null && !matchingRules.isEmpty();
  }
  public MatchingRulesNested<A> addNewMatchingRule() {
    return new MatchingRulesNested(-1, null);
  }
  public MatchingRulesNested<A> addNewMatchingRuleLike(ClusterCondition item) {
    return new MatchingRulesNested(-1, item);
  }
  public MatchingRulesNested<A> setNewMatchingRuleLike(int index,ClusterCondition item) {
    return new MatchingRulesNested(index, item);
  }
  public MatchingRulesNested<A> editMatchingRule(int index) {
    if (matchingRules.size() <= index) throw new RuntimeException("Can't edit matchingRules. Index exceeds size.");
    return setNewMatchingRuleLike(index, buildMatchingRule(index));
  }
  public MatchingRulesNested<A> editFirstMatchingRule() {
    if (matchingRules.size() == 0) throw new RuntimeException("Can't edit first matchingRules. The list is empty.");
    return setNewMatchingRuleLike(0, buildMatchingRule(0));
  }
  public MatchingRulesNested<A> editLastMatchingRule() {
    int index = matchingRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matchingRules. The list is empty.");
    return setNewMatchingRuleLike(index, buildMatchingRule(index));
  }
  public MatchingRulesNested<A> editMatchingMatchingRule(Predicate<ClusterConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matchingRules.size();i++) { 
    if (predicate.test(matchingRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matchingRules. No match found.");
    return setNewMatchingRuleLike(index, buildMatchingRule(index));
  }
  public String getMessage() {
    return this.message;
  }
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  public boolean hasMessage() {
    return this.message != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public boolean hasName() {
    return this.name != null;
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public boolean hasUrl() {
    return this.url != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConditionalUpdateRiskFluent that = (ConditionalUpdateRiskFluent) o;
    if (!java.util.Objects.equals(matchingRules, that.matchingRules)) return false;

    if (!java.util.Objects.equals(message, that.message)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(url, that.url)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(matchingRules,  message,  name,  url,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (matchingRules != null && !matchingRules.isEmpty()) { sb.append("matchingRules:"); sb.append(matchingRules + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MatchingRulesNested<N> extends ClusterConditionFluent<MatchingRulesNested<N>> implements Nested<N>{
    MatchingRulesNested(int index,ClusterCondition item) {
      this.index = index;
      this.builder = new ClusterConditionBuilder(this, item);
    }
    ClusterConditionBuilder builder;
    int index;
    public N and() {
      return (N) ConditionalUpdateRiskFluent.this.setToMatchingRules(index,builder.build());
    }
    public N endMatchingRule() {
      return and();
    }
    
  }
  
}