package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConditionalUpdateRiskBuilder extends ConditionalUpdateRiskFluent<ConditionalUpdateRiskBuilder> implements VisitableBuilder<ConditionalUpdateRisk,ConditionalUpdateRiskBuilder>{
  public ConditionalUpdateRiskBuilder() {
    this(false);
  }
  public ConditionalUpdateRiskBuilder(Boolean validationEnabled) {
    this(new ConditionalUpdateRisk(), validationEnabled);
  }
  public ConditionalUpdateRiskBuilder(ConditionalUpdateRiskFluent<?> fluent) {
    this(fluent, false);
  }
  public ConditionalUpdateRiskBuilder(ConditionalUpdateRiskFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConditionalUpdateRisk(), validationEnabled);
  }
  public ConditionalUpdateRiskBuilder(ConditionalUpdateRiskFluent<?> fluent,ConditionalUpdateRisk instance) {
    this(fluent, instance, false);
  }
  public ConditionalUpdateRiskBuilder(ConditionalUpdateRiskFluent<?> fluent,ConditionalUpdateRisk instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConditionalUpdateRisk());

    if (instance != null) {
      fluent.withMatchingRules(instance.getMatchingRules());
      fluent.withMessage(instance.getMessage());
      fluent.withName(instance.getName());
      fluent.withUrl(instance.getUrl());
      fluent.withMatchingRules(instance.getMatchingRules());
      fluent.withMessage(instance.getMessage());
      fluent.withName(instance.getName());
      fluent.withUrl(instance.getUrl());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConditionalUpdateRiskBuilder(ConditionalUpdateRisk instance) {
    this(instance,false);
  }
  public ConditionalUpdateRiskBuilder(ConditionalUpdateRisk instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConditionalUpdateRisk());

    if (instance != null) {
      this.withMatchingRules(instance.getMatchingRules());
      this.withMessage(instance.getMessage());
      this.withName(instance.getName());
      this.withUrl(instance.getUrl());
      this.withMatchingRules(instance.getMatchingRules());
      this.withMessage(instance.getMessage());
      this.withName(instance.getName());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConditionalUpdateRiskFluent<?> fluent;
  Boolean validationEnabled;
  public ConditionalUpdateRisk build() {
    ConditionalUpdateRisk buildable = new ConditionalUpdateRisk(fluent.buildMatchingRules(),fluent.getMessage(),fluent.getName(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}