package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ComponentOverrideBuilder extends ComponentOverrideFluent<ComponentOverrideBuilder> implements VisitableBuilder<ComponentOverride,ComponentOverrideBuilder>{
  public ComponentOverrideBuilder() {
    this(false);
  }
  public ComponentOverrideBuilder(Boolean validationEnabled) {
    this(new ComponentOverride(), validationEnabled);
  }
  public ComponentOverrideBuilder(ComponentOverrideFluent<?> fluent) {
    this(fluent, false);
  }
  public ComponentOverrideBuilder(ComponentOverrideFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ComponentOverride(), validationEnabled);
  }
  public ComponentOverrideBuilder(ComponentOverrideFluent<?> fluent,ComponentOverride instance) {
    this(fluent, instance, false);
  }
  public ComponentOverrideBuilder(ComponentOverrideFluent<?> fluent,ComponentOverride instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ComponentOverride());

    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withUnmanaged(instance.getUnmanaged());
      fluent.withGroup(instance.getGroup());
      fluent.withKind(instance.getKind());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withUnmanaged(instance.getUnmanaged());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ComponentOverrideBuilder(ComponentOverride instance) {
    this(instance,false);
  }
  public ComponentOverrideBuilder(ComponentOverride instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ComponentOverride());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withUnmanaged(instance.getUnmanaged());
      this.withGroup(instance.getGroup());
      this.withKind(instance.getKind());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withUnmanaged(instance.getUnmanaged());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ComponentOverrideFluent<?> fluent;
  Boolean validationEnabled;
  public ComponentOverride build() {
    ComponentOverride buildable = new ComponentOverride(fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getUnmanaged());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}