package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterVersionStatusBuilder extends ClusterVersionStatusFluent<ClusterVersionStatusBuilder> implements VisitableBuilder<ClusterVersionStatus,ClusterVersionStatusBuilder>{
  public ClusterVersionStatusBuilder() {
    this(false);
  }
  public ClusterVersionStatusBuilder(Boolean validationEnabled) {
    this(new ClusterVersionStatus(), validationEnabled);
  }
  public ClusterVersionStatusBuilder(ClusterVersionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterVersionStatusBuilder(ClusterVersionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterVersionStatus(), validationEnabled);
  }
  public ClusterVersionStatusBuilder(ClusterVersionStatusFluent<?> fluent,ClusterVersionStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterVersionStatusBuilder(ClusterVersionStatusFluent<?> fluent,ClusterVersionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterVersionStatus());

    if (instance != null) {
      fluent.withAvailableUpdates(instance.getAvailableUpdates());
      fluent.withCapabilities(instance.getCapabilities());
      fluent.withConditionalUpdates(instance.getConditionalUpdates());
      fluent.withConditions(instance.getConditions());
      fluent.withDesired(instance.getDesired());
      fluent.withHistory(instance.getHistory());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withVersionHash(instance.getVersionHash());
      fluent.withAvailableUpdates(instance.getAvailableUpdates());
      fluent.withCapabilities(instance.getCapabilities());
      fluent.withConditionalUpdates(instance.getConditionalUpdates());
      fluent.withConditions(instance.getConditions());
      fluent.withDesired(instance.getDesired());
      fluent.withHistory(instance.getHistory());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withVersionHash(instance.getVersionHash());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterVersionStatusBuilder(ClusterVersionStatus instance) {
    this(instance,false);
  }
  public ClusterVersionStatusBuilder(ClusterVersionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterVersionStatus());

    if (instance != null) {
      this.withAvailableUpdates(instance.getAvailableUpdates());
      this.withCapabilities(instance.getCapabilities());
      this.withConditionalUpdates(instance.getConditionalUpdates());
      this.withConditions(instance.getConditions());
      this.withDesired(instance.getDesired());
      this.withHistory(instance.getHistory());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withVersionHash(instance.getVersionHash());
      this.withAvailableUpdates(instance.getAvailableUpdates());
      this.withCapabilities(instance.getCapabilities());
      this.withConditionalUpdates(instance.getConditionalUpdates());
      this.withConditions(instance.getConditions());
      this.withDesired(instance.getDesired());
      this.withHistory(instance.getHistory());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withVersionHash(instance.getVersionHash());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterVersionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterVersionStatus build() {
    ClusterVersionStatus buildable = new ClusterVersionStatus(fluent.buildAvailableUpdates(),fluent.buildCapabilities(),fluent.buildConditionalUpdates(),fluent.buildConditions(),fluent.buildDesired(),fluent.buildHistory(),fluent.getObservedGeneration(),fluent.getVersionHash());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}