package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterNetworkEntryBuilder extends ClusterNetworkEntryFluent<ClusterNetworkEntryBuilder> implements VisitableBuilder<ClusterNetworkEntry,ClusterNetworkEntryBuilder>{
  public ClusterNetworkEntryBuilder() {
    this(false);
  }
  public ClusterNetworkEntryBuilder(Boolean validationEnabled) {
    this(new ClusterNetworkEntry(), validationEnabled);
  }
  public ClusterNetworkEntryBuilder(ClusterNetworkEntryFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterNetworkEntryBuilder(ClusterNetworkEntryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterNetworkEntry(), validationEnabled);
  }
  public ClusterNetworkEntryBuilder(ClusterNetworkEntryFluent<?> fluent,ClusterNetworkEntry instance) {
    this(fluent, instance, false);
  }
  public ClusterNetworkEntryBuilder(ClusterNetworkEntryFluent<?> fluent,ClusterNetworkEntry instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterNetworkEntry());

    if (instance != null) {
      fluent.withCidr(instance.getCidr());
      fluent.withHostPrefix(instance.getHostPrefix());
      fluent.withCidr(instance.getCidr());
      fluent.withHostPrefix(instance.getHostPrefix());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterNetworkEntryBuilder(ClusterNetworkEntry instance) {
    this(instance,false);
  }
  public ClusterNetworkEntryBuilder(ClusterNetworkEntry instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterNetworkEntry());

    if (instance != null) {
      this.withCidr(instance.getCidr());
      this.withHostPrefix(instance.getHostPrefix());
      this.withCidr(instance.getCidr());
      this.withHostPrefix(instance.getHostPrefix());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterNetworkEntryFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterNetworkEntry build() {
    ClusterNetworkEntry buildable = new ClusterNetworkEntry(fluent.getCidr(),fluent.getHostPrefix());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}