package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BuildBuilder extends BuildFluent<BuildBuilder> implements VisitableBuilder<Build,BuildBuilder>{
  public BuildBuilder() {
    this(false);
  }
  public BuildBuilder(Boolean validationEnabled) {
    this(new Build(), validationEnabled);
  }
  public BuildBuilder(BuildFluent<?> fluent) {
    this(fluent, false);
  }
  public BuildBuilder(BuildFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Build(), validationEnabled);
  }
  public BuildBuilder(BuildFluent<?> fluent,Build instance) {
    this(fluent, instance, false);
  }
  public BuildBuilder(BuildFluent<?> fluent,Build instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Build());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BuildBuilder(Build instance) {
    this(instance,false);
  }
  public BuildBuilder(Build instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Build());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BuildFluent<?> fluent;
  Boolean validationEnabled;
  public Build build() {
    Build buildable = new Build(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}