package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BareMetalPlatformLoadBalancerBuilder extends BareMetalPlatformLoadBalancerFluent<BareMetalPlatformLoadBalancerBuilder> implements VisitableBuilder<BareMetalPlatformLoadBalancer,BareMetalPlatformLoadBalancerBuilder>{
  public BareMetalPlatformLoadBalancerBuilder() {
    this(false);
  }
  public BareMetalPlatformLoadBalancerBuilder(Boolean validationEnabled) {
    this(new BareMetalPlatformLoadBalancer(), validationEnabled);
  }
  public BareMetalPlatformLoadBalancerBuilder(BareMetalPlatformLoadBalancerFluent<?> fluent) {
    this(fluent, false);
  }
  public BareMetalPlatformLoadBalancerBuilder(BareMetalPlatformLoadBalancerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BareMetalPlatformLoadBalancer(), validationEnabled);
  }
  public BareMetalPlatformLoadBalancerBuilder(BareMetalPlatformLoadBalancerFluent<?> fluent,BareMetalPlatformLoadBalancer instance) {
    this(fluent, instance, false);
  }
  public BareMetalPlatformLoadBalancerBuilder(BareMetalPlatformLoadBalancerFluent<?> fluent,BareMetalPlatformLoadBalancer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new BareMetalPlatformLoadBalancer());

    if (instance != null) {
      fluent.withType(instance.getType());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BareMetalPlatformLoadBalancerBuilder(BareMetalPlatformLoadBalancer instance) {
    this(instance,false);
  }
  public BareMetalPlatformLoadBalancerBuilder(BareMetalPlatformLoadBalancer instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new BareMetalPlatformLoadBalancer());

    if (instance != null) {
      this.withType(instance.getType());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BareMetalPlatformLoadBalancerFluent<?> fluent;
  Boolean validationEnabled;
  public BareMetalPlatformLoadBalancer build() {
    BareMetalPlatformLoadBalancer buildable = new BareMetalPlatformLoadBalancer(fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}