package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AuditFluent<A extends AuditFluent<A>> extends BaseFluent<A>{
  public AuditFluent() {
  }
  public AuditFluent(Audit instance) {
    instance = (instance != null ? instance : new Audit());

    if (instance != null) {
      this.withCustomRules(instance.getCustomRules());
      this.withProfile(instance.getProfile());
      this.withCustomRules(instance.getCustomRules());
      this.withProfile(instance.getProfile());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<AuditCustomRuleBuilder> customRules = new ArrayList<AuditCustomRuleBuilder>();
  private String profile;
  private Map<String,Object> additionalProperties;
  public A addToCustomRules(int index,AuditCustomRule item) {
    if (this.customRules == null) {this.customRules = new ArrayList<AuditCustomRuleBuilder>();}
    AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
    if (index < 0 || index >= customRules.size()) { _visitables.get("customRules").add(builder); customRules.add(builder); } else { _visitables.get("customRules").add(index, builder); customRules.add(index, builder);}
    return (A)this;
  }
  public A setToCustomRules(int index,AuditCustomRule item) {
    if (this.customRules == null) {this.customRules = new ArrayList<AuditCustomRuleBuilder>();}
    AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);
    if (index < 0 || index >= customRules.size()) { _visitables.get("customRules").add(builder); customRules.add(builder); } else { _visitables.get("customRules").set(index, builder); customRules.set(index, builder);}
    return (A)this;
  }
  public A addToCustomRules(io.fabric8.openshift.api.model.config.v1.AuditCustomRule... items) {
    if (this.customRules == null) {this.customRules = new ArrayList<AuditCustomRuleBuilder>();}
    for (AuditCustomRule item : items) {AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);_visitables.get("customRules").add(builder);this.customRules.add(builder);} return (A)this;
  }
  public A addAllToCustomRules(Collection<AuditCustomRule> items) {
    if (this.customRules == null) {this.customRules = new ArrayList<AuditCustomRuleBuilder>();}
    for (AuditCustomRule item : items) {AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);_visitables.get("customRules").add(builder);this.customRules.add(builder);} return (A)this;
  }
  public A removeFromCustomRules(io.fabric8.openshift.api.model.config.v1.AuditCustomRule... items) {
    if (this.customRules == null) return (A)this;
    for (AuditCustomRule item : items) {AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);_visitables.get("customRules").remove(builder); this.customRules.remove(builder);} return (A)this;
  }
  public A removeAllFromCustomRules(Collection<AuditCustomRule> items) {
    if (this.customRules == null) return (A)this;
    for (AuditCustomRule item : items) {AuditCustomRuleBuilder builder = new AuditCustomRuleBuilder(item);_visitables.get("customRules").remove(builder); this.customRules.remove(builder);} return (A)this;
  }
  public A removeMatchingFromCustomRules(Predicate<AuditCustomRuleBuilder> predicate) {
    if (customRules == null) return (A) this;
    final Iterator<AuditCustomRuleBuilder> each = customRules.iterator();
    final List visitables = _visitables.get("customRules");
    while (each.hasNext()) {
      AuditCustomRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<AuditCustomRule> buildCustomRules() {
    return customRules != null ? build(customRules) : null;
  }
  public AuditCustomRule buildCustomRule(int index) {
    return this.customRules.get(index).build();
  }
  public AuditCustomRule buildFirstCustomRule() {
    return this.customRules.get(0).build();
  }
  public AuditCustomRule buildLastCustomRule() {
    return this.customRules.get(customRules.size() - 1).build();
  }
  public AuditCustomRule buildMatchingCustomRule(Predicate<AuditCustomRuleBuilder> predicate) {
    for (AuditCustomRuleBuilder item: customRules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingCustomRule(Predicate<AuditCustomRuleBuilder> predicate) {
    for (AuditCustomRuleBuilder item: customRules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCustomRules(List<AuditCustomRule> customRules) {
    if (this.customRules != null) { _visitables.get("customRules").clear();}
    if (customRules != null) {this.customRules = new ArrayList(); for (AuditCustomRule item : customRules){this.addToCustomRules(item);}} else { this.customRules = null;} return (A) this;
  }
  public A withCustomRules(io.fabric8.openshift.api.model.config.v1.AuditCustomRule... customRules) {
    if (this.customRules != null) {this.customRules.clear(); _visitables.remove("customRules"); }
    if (customRules != null) {for (AuditCustomRule item :customRules){ this.addToCustomRules(item);}} return (A) this;
  }
  public boolean hasCustomRules() {
    return customRules != null && !customRules.isEmpty();
  }
  public A addNewCustomRule(String group,String profile) {
    return (A)addToCustomRules(new AuditCustomRule(group, profile));
  }
  public CustomRulesNested<A> addNewCustomRule() {
    return new CustomRulesNested(-1, null);
  }
  public CustomRulesNested<A> addNewCustomRuleLike(AuditCustomRule item) {
    return new CustomRulesNested(-1, item);
  }
  public CustomRulesNested<A> setNewCustomRuleLike(int index,AuditCustomRule item) {
    return new CustomRulesNested(index, item);
  }
  public CustomRulesNested<A> editCustomRule(int index) {
    if (customRules.size() <= index) throw new RuntimeException("Can't edit customRules. Index exceeds size.");
    return setNewCustomRuleLike(index, buildCustomRule(index));
  }
  public CustomRulesNested<A> editFirstCustomRule() {
    if (customRules.size() == 0) throw new RuntimeException("Can't edit first customRules. The list is empty.");
    return setNewCustomRuleLike(0, buildCustomRule(0));
  }
  public CustomRulesNested<A> editLastCustomRule() {
    int index = customRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last customRules. The list is empty.");
    return setNewCustomRuleLike(index, buildCustomRule(index));
  }
  public CustomRulesNested<A> editMatchingCustomRule(Predicate<AuditCustomRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<customRules.size();i++) { 
    if (predicate.test(customRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching customRules. No match found.");
    return setNewCustomRuleLike(index, buildCustomRule(index));
  }
  public String getProfile() {
    return this.profile;
  }
  public A withProfile(String profile) {
    this.profile=profile; return (A) this;
  }
  public boolean hasProfile() {
    return this.profile != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AuditFluent that = (AuditFluent) o;
    if (!java.util.Objects.equals(customRules, that.customRules)) return false;

    if (!java.util.Objects.equals(profile, that.profile)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(customRules,  profile,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (customRules != null && !customRules.isEmpty()) { sb.append("customRules:"); sb.append(customRules + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CustomRulesNested<N> extends AuditCustomRuleFluent<CustomRulesNested<N>> implements Nested<N>{
    CustomRulesNested(int index,AuditCustomRule item) {
      this.index = index;
      this.builder = new AuditCustomRuleBuilder(this, item);
    }
    AuditCustomRuleBuilder builder;
    int index;
    public N and() {
      return (N) AuditFluent.this.setToCustomRules(index,builder.build());
    }
    public N endCustomRule() {
      return and();
    }
    
  }
  
}