package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSIngressSpecBuilder extends AWSIngressSpecFluent<AWSIngressSpecBuilder> implements VisitableBuilder<AWSIngressSpec,AWSIngressSpecBuilder>{
  public AWSIngressSpecBuilder() {
    this(false);
  }
  public AWSIngressSpecBuilder(Boolean validationEnabled) {
    this(new AWSIngressSpec(), validationEnabled);
  }
  public AWSIngressSpecBuilder(AWSIngressSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSIngressSpecBuilder(AWSIngressSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSIngressSpec(), validationEnabled);
  }
  public AWSIngressSpecBuilder(AWSIngressSpecFluent<?> fluent,AWSIngressSpec instance) {
    this(fluent, instance, false);
  }
  public AWSIngressSpecBuilder(AWSIngressSpecFluent<?> fluent,AWSIngressSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AWSIngressSpec());

    if (instance != null) {
      fluent.withType(instance.getType());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSIngressSpecBuilder(AWSIngressSpec instance) {
    this(instance,false);
  }
  public AWSIngressSpecBuilder(AWSIngressSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AWSIngressSpec());

    if (instance != null) {
      this.withType(instance.getType());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSIngressSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AWSIngressSpec build() {
    AWSIngressSpec buildable = new AWSIngressSpec(fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}