package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSDNSSpecBuilder extends AWSDNSSpecFluent<AWSDNSSpecBuilder> implements VisitableBuilder<AWSDNSSpec,AWSDNSSpecBuilder>{
  public AWSDNSSpecBuilder() {
    this(false);
  }
  public AWSDNSSpecBuilder(Boolean validationEnabled) {
    this(new AWSDNSSpec(), validationEnabled);
  }
  public AWSDNSSpecBuilder(AWSDNSSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSDNSSpecBuilder(AWSDNSSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSDNSSpec(), validationEnabled);
  }
  public AWSDNSSpecBuilder(AWSDNSSpecFluent<?> fluent,AWSDNSSpec instance) {
    this(fluent, instance, false);
  }
  public AWSDNSSpecBuilder(AWSDNSSpecFluent<?> fluent,AWSDNSSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AWSDNSSpec());

    if (instance != null) {
      fluent.withPrivateZoneIAMRole(instance.getPrivateZoneIAMRole());
      fluent.withPrivateZoneIAMRole(instance.getPrivateZoneIAMRole());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSDNSSpecBuilder(AWSDNSSpec instance) {
    this(instance,false);
  }
  public AWSDNSSpecBuilder(AWSDNSSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AWSDNSSpec());

    if (instance != null) {
      this.withPrivateZoneIAMRole(instance.getPrivateZoneIAMRole());
      this.withPrivateZoneIAMRole(instance.getPrivateZoneIAMRole());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSDNSSpecFluent<?> fluent;
  Boolean validationEnabled;
  public AWSDNSSpec build() {
    AWSDNSSpec buildable = new AWSDNSSpec(fluent.getPrivateZoneIAMRole());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}