package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VSpherePlatformSpecBuilder extends VSpherePlatformSpecFluentImpl<VSpherePlatformSpecBuilder> implements VisitableBuilder<VSpherePlatformSpec,VSpherePlatformSpecBuilder>{
  public VSpherePlatformSpecBuilder() {
    this(false);
  }
  public VSpherePlatformSpecBuilder(Boolean validationEnabled) {
    this(new VSpherePlatformSpec(), validationEnabled);
  }
  public VSpherePlatformSpecBuilder(VSpherePlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public VSpherePlatformSpecBuilder(VSpherePlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VSpherePlatformSpec(), validationEnabled);
  }
  public VSpherePlatformSpecBuilder(VSpherePlatformSpecFluent<?> fluent,VSpherePlatformSpec instance) {
    this(fluent, instance, false);
  }
  public VSpherePlatformSpecBuilder(VSpherePlatformSpecFluent<?> fluent,VSpherePlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VSpherePlatformSpecBuilder(VSpherePlatformSpec instance) {
    this(instance,false);
  }
  public VSpherePlatformSpecBuilder(VSpherePlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VSpherePlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public VSpherePlatformSpec build() {
    VSpherePlatformSpec buildable = new VSpherePlatformSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}