package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TemplateReferenceBuilder extends TemplateReferenceFluentImpl<TemplateReferenceBuilder> implements VisitableBuilder<TemplateReference,TemplateReferenceBuilder>{
  public TemplateReferenceBuilder() {
    this(false);
  }
  public TemplateReferenceBuilder(Boolean validationEnabled) {
    this(new TemplateReference(), validationEnabled);
  }
  public TemplateReferenceBuilder(TemplateReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public TemplateReferenceBuilder(TemplateReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TemplateReference(), validationEnabled);
  }
  public TemplateReferenceBuilder(TemplateReferenceFluent<?> fluent,TemplateReference instance) {
    this(fluent, instance, false);
  }
  public TemplateReferenceBuilder(TemplateReferenceFluent<?> fluent,TemplateReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TemplateReferenceBuilder(TemplateReference instance) {
    this(instance,false);
  }
  public TemplateReferenceBuilder(TemplateReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TemplateReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public TemplateReference build() {
    TemplateReference buildable = new TemplateReference(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}