package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SchedulerStatusBuilder extends SchedulerStatusFluentImpl<SchedulerStatusBuilder> implements VisitableBuilder<SchedulerStatus,SchedulerStatusBuilder>{
  public SchedulerStatusBuilder() {
    this(false);
  }
  public SchedulerStatusBuilder(Boolean validationEnabled) {
    this(new SchedulerStatus(), validationEnabled);
  }
  public SchedulerStatusBuilder(SchedulerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SchedulerStatusBuilder(SchedulerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SchedulerStatus(), validationEnabled);
  }
  public SchedulerStatusBuilder(SchedulerStatusFluent<?> fluent,SchedulerStatus instance) {
    this(fluent, instance, false);
  }
  public SchedulerStatusBuilder(SchedulerStatusFluent<?> fluent,SchedulerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SchedulerStatusBuilder(SchedulerStatus instance) {
    this(instance,false);
  }
  public SchedulerStatusBuilder(SchedulerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SchedulerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SchedulerStatus build() {
    SchedulerStatus buildable = new SchedulerStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}